/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Statement;
import java.util.Map;
import java.util.Objects;

public class Explain
extends Statement {
    private final Statement statement;
    private final Map<Option, Boolean> options;

    public Explain(Statement statement, Map<Option, Boolean> options) {
        this.statement = Objects.requireNonNull(statement, "statement is null");
        this.options = options;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Map<Option, Boolean> options() {
        return this.options;
    }

    public boolean isOptionActivated(Option option) {
        return this.options.containsKey((Object)option) && (this.options.get((Object)option) == null || this.options.get((Object)option) == true);
    }

    public boolean isOptionExplicitlyDeactivated(Option option) {
        return this.options.containsKey((Object)option) && this.options.get((Object)option) == false;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExplain(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Explain explain = (Explain)o;
        return Objects.equals(this.statement, explain.statement) && Objects.equals(this.options, explain.options);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.statement, this.options);
    }

    @Override
    public String toString() {
        return "Explain{statement=" + String.valueOf(this.statement) + ", options=" + String.valueOf(this.options) + "}";
    }

    public static enum Option {
        ANALYZE,
        COSTS,
        VERBOSE;

    }
}

