/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Node;
import java.util.List;
import java.util.Objects;

public class GroupBy
extends Node {
    private final boolean isAll;
    private final List<Expression> expressions;

    private GroupBy(boolean isAll, List<Expression> expressions) {
        this.isAll = isAll;
        this.expressions = Objects.requireNonNull(expressions, "expressions is null");
    }

    public static GroupBy all() {
        return new GroupBy(true, List.of());
    }

    public static GroupBy of(List<Expression> expressions) {
        return new GroupBy(false, expressions);
    }

    public boolean isAll() {
        return this.isAll;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGroupBy(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupBy groupBy = (GroupBy)o;
        return this.isAll == groupBy.isAll && Objects.equals(this.expressions, groupBy.expressions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isAll, this.expressions);
    }

    @Override
    public String toString() {
        return "GroupBy{isAll=" + this.isAll + ", expressions=" + String.valueOf(this.expressions) + "}";
    }
}

