/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import java.util.Objects;

public class LikePredicate
extends Expression {
    private final Expression value;
    private final Expression pattern;
    private final Expression escape;
    private final boolean ignoreCase;

    public LikePredicate(Expression value, Expression pattern, Expression escape, boolean ignoreCase) {
        this.value = Objects.requireNonNull(value, "value is null");
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.escape = escape;
        this.ignoreCase = ignoreCase;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getPattern() {
        return this.pattern;
    }

    public Expression getEscape() {
        return this.escape;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLikePredicate(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LikePredicate that = (LikePredicate)o;
        return this.ignoreCase == that.ignoreCase && Objects.equals(this.value, that.value) && Objects.equals(this.pattern, that.pattern) && Objects.equals(this.escape, that.escape);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.pattern, this.escape, this.ignoreCase);
    }
}

