/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.common.collections.Lists;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Node;
import java.util.List;
import java.util.function.Function;

public final class PartitionedBy<T>
extends Node {
    private final List<T> columns;

    public PartitionedBy(List<T> columns) {
        this.columns = columns;
    }

    public List<T> columns() {
        return this.columns;
    }

    public <U> PartitionedBy<U> map(Function<? super T, ? extends U> mapper) {
        return new PartitionedBy<T>(Lists.map(this.columns, mapper));
    }

    @Override
    public int hashCode() {
        return this.columns.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PartitionedBy)) return false;
        PartitionedBy that = (PartitionedBy)o;
        if (!this.columns.equals(that.columns)) return false;
        return true;
    }

    @Override
    public String toString() {
        return "PartitionedBy{columns=" + String.valueOf(this.columns) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPartitionedBy(this, context);
    }
}

