/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.DenyPrivilege;
import io.crate.sql.tree.GrantPrivilege;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.RevokePrivilege;
import io.crate.sql.tree.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract sealed class PrivilegeStatement
extends Statement
permits GrantPrivilege, RevokePrivilege, DenyPrivilege {
    protected final List<String> userNames;
    protected final List<String> permissions;
    private final List<QualifiedName> tableOrSchemaNames;
    private final String securable;
    protected final boolean all;

    protected PrivilegeStatement(List<String> userNames, String securable, List<QualifiedName> tableOrSchemaNames) {
        this.userNames = userNames;
        this.permissions = Collections.emptyList();
        this.all = true;
        this.securable = securable;
        this.tableOrSchemaNames = tableOrSchemaNames;
    }

    protected PrivilegeStatement(List<String> userNames, List<String> permissions, String securable, List<QualifiedName> tableOrSchemaNames) {
        this.userNames = userNames;
        this.permissions = permissions;
        this.all = false;
        this.securable = securable;
        this.tableOrSchemaNames = tableOrSchemaNames;
    }

    public List<String> privileges() {
        return this.permissions;
    }

    public List<String> userNames() {
        return this.userNames;
    }

    public boolean all() {
        return this.all;
    }

    public List<QualifiedName> privilegeIdents() {
        return this.tableOrSchemaNames;
    }

    public String securable() {
        return this.securable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PrivilegeStatement)) return false;
        PrivilegeStatement that = (PrivilegeStatement)o;
        if (this.all != that.all) return false;
        if (!Objects.equals(this.userNames, that.userNames)) return false;
        if (!Objects.equals(this.permissions, that.permissions)) return false;
        if (!Objects.equals(this.securable, that.securable)) return false;
        if (!Objects.equals(this.tableOrSchemaNames, that.tableOrSchemaNames)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.all, this.userNames, this.permissions, this.securable, this.tableOrSchemaNames);
    }
}

