/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class StringUtils {
    public static final ThreadLocal<long[]> PARSE_LONG_BUFFER = ThreadLocal.withInitial(() -> new long[1]);

    private StringUtils() {
    }

    public static List<String> splitToList(char delim, String value) {
        ArrayList<String> result = new ArrayList<String>();
        int lastStart = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != delim) continue;
            result.add(value.substring(lastStart, i));
            lastStart = i + 1;
        }
        if (lastStart <= value.length()) {
            result.add(value.substring(lastStart));
        }
        return result;
    }

    public static boolean isBlank(String string, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (Character.isSpaceChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String camelToSnakeCase(String camelCase) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < camelCase.length(); ++i) {
            char c = camelCase.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1).toLowerCase(Locale.ENGLISH);
    }

    public static String padEnd(String s, int minimumLength, char c) {
        if (s == null) {
            throw new NullPointerException("s");
        }
        if (s.length() >= minimumLength) {
            return s;
        }
        return s + String.valueOf(c).repeat(minimumLength - s.length());
    }

    public static String trim(String target, char charToTrim) {
        int start;
        int len = target.length();
        for (start = 0; start < len && target.charAt(start) == charToTrim; ++start) {
        }
        while (start < len && target.charAt(len - 1) == charToTrim) {
            --len;
        }
        return target.substring(start, len);
    }

    public static boolean tryParseLong(String s, long[] out) {
        boolean negative = false;
        int radix = 10;
        int i = 0;
        int len = s.length();
        long limit = -9223372036854775807L;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    return false;
                }
                if (len == 1) {
                    return false;
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            long result = 0L;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0 || result < multmin) {
                    return false;
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    return false;
                }
                result -= (long)digit;
            }
            out[0] = negative ? result : -result;
            return true;
        }
        return false;
    }
}

