/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import java.util.EnumSet;
import java.util.Set;

public class EnumSets {
    public static <E extends Enum<E>> int packToInt(Set<E> set) {
        assert (set.size() < 32) : "EnumSet must be smaller than 32";
        int i = 0;
        for (Enum element : set) {
            i |= 1 << element.ordinal();
        }
        return i;
    }

    public static <E extends Enum<E>> EnumSet<E> unpackFromInt(int i, Class<E> enumType) {
        EnumSet<Enum> result = EnumSet.noneOf(enumType);
        for (Enum element : (Enum[])enumType.getEnumConstants()) {
            if ((i & 1 << element.ordinal()) == 0) continue;
            result.add(element);
        }
        return result;
    }
}

