/*
 * Decompiled with CFR 0.152.
 */
package io.crate.beans;

import io.crate.beans.ThreadPoolsMXBean;
import java.beans.ConstructorProperties;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.ThreadPoolStats;
import org.jetbrains.annotations.Nullable;

public class ThreadPools
implements ThreadPoolsMXBean {
    public static final String NAME = "io.crate.monitoring:type=ThreadPools";
    private final ThreadPool threadPool;

    public ThreadPools(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    @Nullable
    private ThreadPoolInfo getThreadPoolInfo(String name) {
        ThreadPoolStats.Stats stats = this.threadPool.stats(name);
        if (stats == null) {
            return null;
        }
        return new ThreadPoolInfo(name, stats.threads(), stats.queue(), stats.largest(), stats.active(), stats.completed(), stats.rejected());
    }

    @Override
    public ThreadPoolInfo getGeneric() {
        return this.getThreadPoolInfo("generic");
    }

    @Override
    public ThreadPoolInfo getListener() {
        return this.getThreadPoolInfo("listener");
    }

    @Override
    public ThreadPoolInfo getWrite() {
        return this.getThreadPoolInfo("write");
    }

    @Override
    public ThreadPoolInfo getSearch() {
        return this.getThreadPoolInfo("search");
    }

    @Override
    public ThreadPoolInfo getManagement() {
        return this.getThreadPoolInfo("management");
    }

    @Override
    public ThreadPoolInfo getFlush() {
        return this.getThreadPoolInfo("flush");
    }

    @Override
    public ThreadPoolInfo getRefresh() {
        return this.getThreadPoolInfo("refresh");
    }

    @Override
    public ThreadPoolInfo getSnapshot() {
        return this.getThreadPoolInfo("snapshot");
    }

    @Override
    public ThreadPoolInfo getForceMerge() {
        return this.getThreadPoolInfo("force_merge");
    }

    @Override
    public ThreadPoolInfo getFetchShardStarted() {
        return this.getThreadPoolInfo("fetch_shard_started");
    }

    @Override
    public ThreadPoolInfo getFetchShardStore() {
        return this.getThreadPoolInfo("fetch_shard_store");
    }

    @Override
    public ThreadPoolInfo getLogicalReplication() {
        return this.getThreadPoolInfo("logical_replication");
    }

    public static class ThreadPoolInfo {
        private final String name;
        private final int poolSize;
        private final int queueSize;
        private final int largestPoolSize;
        private final int active;
        private final long completed;
        private final long rejected;

        @ConstructorProperties(value={"name", "poolSize", "queueSize", "largestPoolSize", "active", "completed", "rejected"})
        public ThreadPoolInfo(String name, int poolSize, int queueSize, int largestPoolSize, int active, long completed, long rejected) {
            this.name = name;
            this.poolSize = poolSize;
            this.queueSize = queueSize;
            this.largestPoolSize = largestPoolSize;
            this.active = active;
            this.completed = completed;
            this.rejected = rejected;
        }

        public String getName() {
            return this.name;
        }

        public int getPoolSize() {
            return this.poolSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public int getLargestPoolSize() {
            return this.largestPoolSize;
        }

        public int getActive() {
            return this.active;
        }

        public long getCompleted() {
            return this.completed;
        }

        public long getRejected() {
            return this.rejected;
        }
    }
}

