/*
 * Decompiled with CFR 0.152.
 */
package io.crate.plugin;

import io.crate.beans.CircuitBreakers;
import io.crate.beans.Connections;
import io.crate.beans.NodeInfo;
import io.crate.beans.NodeStatus;
import io.crate.beans.QueryStats;
import io.crate.beans.ThreadPools;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.protocols.postgres.PostgresNetty;
import io.crate.session.Sessions;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public class CrateMonitor {
    private final Logger logger;
    private final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    @Inject
    public CrateMonitor(JobsLogs jobsLogs, PostgresNetty postgresNetty, @Nullable HttpServerTransport httpServerTransport, TransportService transportService, Sessions sqlOperations, ClusterService clusterService, ThreadPool threadPool, CircuitBreakerService breakerService, IndicesService indicesService) {
        this.logger = LogManager.getLogger(CrateMonitor.class);
        this.registerMBean("io.crate.monitoring:type=QueryStats", new QueryStats(jobsLogs));
        this.registerMBean("io.crate.monitoring:type=NodeStatus", new NodeStatus(() -> ((Sessions)sqlOperations).isEnabled()));
        this.registerMBean("io.crate.monitoring:type=NodeInfo", new NodeInfo(() -> ((ClusterService)clusterService).state(), new NodeInfo.ShardStateAndSizeProvider(indicesService)));
        this.registerMBean("io.crate.monitoring:type=Connections", new Connections(() -> httpServerTransport == null ? null : httpServerTransport.stats(), () -> ((PostgresNetty)postgresNetty).stats(), () -> ((TransportService)transportService).stats()));
        this.registerMBean("io.crate.monitoring:type=ThreadPools", new ThreadPools(threadPool));
        this.registerMBean("io.crate.monitoring:type=CircuitBreakers", new CircuitBreakers(breakerService));
    }

    private void registerMBean(String name, Object bean) {
        try {
            this.mbeanServer.registerMBean(bean, new ObjectName(name));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            this.logger.error("The MBean: {} cannot be registered: {}", (Object)name, (Object)e);
        }
    }
}

