/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.DecodingErrorHandler;
import com.oracle.truffle.api.strings.InternalErrors;
import com.oracle.truffle.api.strings.TStringConstants;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringOps;
import com.oracle.truffle.api.strings.TranscodingErrorHandler;
import com.oracle.truffle.api.strings.TruffleString;

final class Encodings {
    static final int SUPPORTED_ENCODINGS_MIN_NUM = 0;
    static final int SUPPORTED_ENCODINGS_MAX_NUM = 6;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    static final byte[] UTF_8_STATE_MACHINE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 12, 24, 36, 60, 96, 84, 12, 12, 12, 48, 72, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 12, 0, 12, 0, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    @CompilerDirectives.CompilationFinal(dimensions=1)
    static final byte[] UTF_8_STATE_MACHINE_ALLOW_UTF16_SURROGATES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 12, 24, 36, 60, 96, 84, 12, 12, 12, 48, 72, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 12, 0, 12, 0, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    @CompilerDirectives.CompilationFinal(dimensions=1)
    static final byte[] UTF_8_STATE_MACHINE_REVERSE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 36, 12, 12, 12, 12, 12, 48, 12, 60, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 12, 72, 0, 24, 24, 24, 24, 96, 12, 84, 12, 12, 12, 72, 0, 24, 12, 12, 24, 96, 12, 84, 24, 24, 12, 72, 0, 24, 24, 12, 24, 96, 12, 84, 12, 24, 12, 108, 12, 0, 0, 24, 24, 120, 12, 120, 12, 12, 12, 108, 12, 0, 0, 12, 24, 120, 12, 120, 12, 24, 12, 108, 12, 0, 12, 12, 24, 120, 12, 120, 0, 24, 12, 12, 12, 12, 12, 0, 0, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 0};
    @CompilerDirectives.CompilationFinal(dimensions=1)
    static final byte[] UTF_8_STATE_MACHINE_REVERSE_ALLOW_UTF16_SURROGATES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 36, 12, 12, 12, 12, 12, 48, 12, 60, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 12, 72, 0, 24, 24, 24, 24, 96, 12, 84, 12, 12, 12, 72, 0, 24, 12, 12, 24, 96, 12, 84, 24, 24, 12, 72, 0, 24, 24, 12, 24, 96, 12, 84, 12, 24, 12, 108, 12, 0, 0, 24, 24, 120, 12, 120, 12, 12, 12, 108, 12, 0, 0, 12, 24, 120, 12, 120, 12, 24, 12, 108, 12, 0, 12, 12, 24, 120, 12, 120, 0, 24, 12, 12, 12, 12, 12, 0, 0, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 0};
    static final byte UTF8_ACCEPT = 0;
    static final byte UTF8_REJECT = 12;
    static final byte UTF8_REVERSE_INCOMPLETE_SEQ = 24;
    static final byte[] CONVERSION_REPLACEMENT_UTF_8 = new byte[]{-17, -65, -67};
    @CompilerDirectives.CompilationFinal(dimensions=1)
    static final int[] UTF_8_MIN_CODEPOINT = new int[]{0, 0, 128, 2048, 65536};

    Encodings() {
    }

    static byte[] getUTF8DecodingStateMachine(DecodingErrorHandler errorHandler) {
        return errorHandler == DecodingErrorHandler.DEFAULT_KEEP_SURROGATES_IN_UTF8 ? UTF_8_STATE_MACHINE_ALLOW_UTF16_SURROGATES : UTF_8_STATE_MACHINE;
    }

    static byte[] getUTF8DecodingStateMachineReverse(DecodingErrorHandler errorHandler) {
        return errorHandler == DecodingErrorHandler.DEFAULT_KEEP_SURROGATES_IN_UTF8 ? UTF_8_STATE_MACHINE_REVERSE_ALLOW_UTF16_SURROGATES : UTF_8_STATE_MACHINE_REVERSE;
    }

    static boolean isUTF16Surrogate(int c) {
        return c >> 11 == 27;
    }

    static boolean isUTF16HighSurrogate(int c) {
        return c >> 10 == 54;
    }

    static boolean isUTF16LowSurrogate(int c) {
        return c >> 10 == 55;
    }

    static boolean isUTF8ContinuationByte(int b) {
        return (b & 0xC0) == 128;
    }

    static int invalidCodepoint() {
        return 65533;
    }

    static int utf8CodePointLength(int firstByte) {
        return Integer.numberOfLeadingZeros(~(firstByte << 24));
    }

    static int utf8EncodedSize(int codepoint) {
        if (codepoint < 128) {
            return 1;
        }
        if (codepoint < 2048) {
            return 2;
        }
        if (codepoint < 65536) {
            return 3;
        }
        return 4;
    }

    private static boolean isUTF8ContinuationByte(Object arrayA, int offsetA, int lengthA, int index) {
        return Encodings.isUTF8ContinuationByte(TStringOps.readS0(arrayA, offsetA, lengthA, index));
    }

    static byte[] utf8Encode(int codepoint) {
        int n = Encodings.utf8EncodedSize(codepoint);
        byte[] ret = new byte[n];
        if (n == 1) {
            ret[0] = (byte)codepoint;
            return ret;
        }
        Encodings.utf8Encode(codepoint, n, ret, 0);
        return ret;
    }

    static byte[] utf8EncodeNonAscii(int codepoint, int encodedSize) {
        assert (encodedSize == Encodings.utf8EncodedSize(codepoint));
        assert (encodedSize > 1);
        byte[] ret = new byte[encodedSize];
        Encodings.utf8Encode(codepoint, encodedSize, ret, 0);
        return ret;
    }

    static void utf8Encode(int codepoint, byte[] buffer, int index, int length) {
        assert (length == Encodings.utf8EncodedSize(codepoint));
        if (length == 1) {
            buffer[index] = (byte)codepoint;
        } else {
            Encodings.utf8Encode(codepoint, length, buffer, index);
        }
    }

    private static void utf8Encode(int codepoint, int encodedLength, byte[] buffer, int index) {
        assert (index >= 0);
        assert (2 <= encodedLength && encodedLength <= 4);
        int i = index + encodedLength;
        int c = codepoint;
        switch (encodedLength) {
            case 4: {
                buffer[--i] = (byte)(0x80 | c & 0x3F);
                c >>>= 6;
            }
            case 3: {
                buffer[--i] = (byte)(0x80 | c & 0x3F);
                c >>>= 6;
            }
        }
        buffer[--i] = (byte)(0x80 | c & 0x3F);
        buffer[--i] = (byte)(3840 >>> encodedLength | (c >>>= 6));
    }

    static int utf8CodePointToByteIndex(Node location, AbstractTruffleString a, Object arrayA, int codePointIndex) {
        int iCP = 0;
        int iBytes = 0;
        int lengthA = a.length();
        while (CompilerDirectives.injectBranchProbability(0.75, iBytes < lengthA)) {
            if ((TStringOps.readS0(a, arrayA, iBytes) & 0xC0) != 128) {
                if (CompilerDirectives.injectBranchProbability(0.01, iCP >= codePointIndex)) break;
                ++iCP;
            }
            TStringConstants.truffleSafePointPoll(location, ++iBytes);
        }
        if (iBytes >= lengthA) {
            throw InternalErrors.indexOutOfBounds(lengthA, iBytes);
        }
        return iBytes;
    }

    static int utf8DecodeValid(AbstractTruffleString a, Object arrayA, int i) {
        return Encodings.utf8DecodeValid(arrayA, a.offset(), a.length(), i);
    }

    static int utf8DecodeValid(Object arrayA, int offsetA, int lengthA, int i) {
        int b = TStringOps.readS0(arrayA, offsetA, lengthA, i);
        if (b < 128) {
            return b;
        }
        int nBytes = Encodings.utf8CodePointLength(b);
        int codepoint = b & 255 >>> nBytes;
        assert (1 < nBytes && nBytes < 5) : nBytes;
        assert (i + nBytes <= lengthA);
        int j = i + 1;
        switch (nBytes) {
            case 4: {
                assert (Encodings.isUTF8ContinuationByte(arrayA, offsetA, lengthA, j));
                codepoint = codepoint << 6 | TStringOps.readS0(arrayA, offsetA, lengthA, j++) & 0x3F;
            }
            case 3: {
                assert (Encodings.isUTF8ContinuationByte(arrayA, offsetA, lengthA, j));
                codepoint = codepoint << 6 | TStringOps.readS0(arrayA, offsetA, lengthA, j++) & 0x3F;
            }
        }
        assert (Encodings.isUTF8ContinuationByte(arrayA, offsetA, lengthA, j));
        codepoint = codepoint << 6 | TStringOps.readS0(arrayA, offsetA, lengthA, j) & 0x3F;
        return codepoint;
    }

    static int utf8DecodeBroken(AbstractTruffleString a, Object arrayA, int i, TruffleString.ErrorHandling errorHandling) {
        return Encodings.utf8DecodeBroken(arrayA, a.offset(), a.length(), i, errorHandling);
    }

    static int utf8DecodeBroken(Object arrayA, int offsetA, int lengthA, int i, TruffleString.ErrorHandling errorHandling) {
        int b = TStringOps.readS0(arrayA, offsetA, lengthA, i);
        if (b < 128) {
            return b;
        }
        int nBytes = Encodings.utf8CodePointLength(b);
        int codepoint = b & 255 >>> nBytes;
        int j = i + 1;
        switch (nBytes) {
            case 4: {
                if (j >= lengthA || !Encodings.isUTF8ContinuationByte(arrayA, offsetA, lengthA, j)) {
                    return Encodings.invalidCodepointReturnValue(errorHandling);
                }
                codepoint = codepoint << 6 | TStringOps.readS0(arrayA, offsetA, lengthA, j++) & 0x3F;
            }
            case 3: {
                if (j >= lengthA || !Encodings.isUTF8ContinuationByte(arrayA, offsetA, lengthA, j)) {
                    return Encodings.invalidCodepointReturnValue(errorHandling);
                }
                codepoint = codepoint << 6 | TStringOps.readS0(arrayA, offsetA, lengthA, j++) & 0x3F;
            }
            case 2: {
                if (j >= lengthA || !Encodings.isUTF8ContinuationByte(arrayA, offsetA, lengthA, j)) {
                    return Encodings.invalidCodepointReturnValue(errorHandling);
                }
                codepoint = codepoint << 6 | TStringOps.readS0(arrayA, offsetA, lengthA, j) & 0x3F;
                break;
            }
            default: {
                return Encodings.invalidCodepointReturnValue(errorHandling);
            }
        }
        if (Encodings.utf8IsInvalidCodePoint(codepoint, nBytes)) {
            return Encodings.invalidCodepointReturnValue(errorHandling);
        }
        return codepoint;
    }

    static int utf8GetCodePointLength(AbstractTruffleString a, Object arrayA, int i, DecodingErrorHandler errorHandler) {
        return Encodings.utf8GetCodePointLength(arrayA, a.offset(), a.length(), i, errorHandler);
    }

    static int utf8GetCodePointLength(Object arrayA, int offset, int length, int i, DecodingErrorHandler errorHandler) {
        int j;
        assert (TStringGuards.isBuiltin(errorHandler));
        int b = TStringOps.readS0(arrayA, offset, length, i);
        if (b < 128) {
            return 1;
        }
        int nBytes = Encodings.utf8CodePointLength(b);
        byte[] stateMachine = Encodings.getUTF8DecodingStateMachine(errorHandler);
        byte type = stateMachine[b];
        byte state = stateMachine[256 + type];
        if (state != 12) {
            for (j = i + 1; j < Math.min(length, i + nBytes) && (state = stateMachine[256 + state + (type = stateMachine[b = TStringOps.readS0(arrayA, offset, length, j)])]) != 12; ++j) {
            }
        }
        if (state == 0) {
            return nBytes;
        }
        if (TStringGuards.isDefaultVariant(errorHandler)) {
            if (errorHandler == DecodingErrorHandler.DEFAULT) {
                return 1;
            }
            return j - i;
        }
        assert (TStringGuards.isReturnNegative(errorHandler));
        if (j == length && state != 12) {
            return length - (i + nBytes) - 1;
        }
        return -1;
    }

    static boolean utf8IsInvalidCodePoint(int codepoint, int nBytes) {
        return Encodings.isUTF16Surrogate(codepoint) || codepoint < UTF_8_MIN_CODEPOINT[nBytes] || codepoint > 0x10FFFF;
    }

    static int invalidCodepointReturnValue(TruffleString.ErrorHandling errorHandling) {
        return Encodings.invalidCodepointReturnValue(Encodings.invalidCodepoint(), errorHandling);
    }

    static int invalidCodepointReturnValue(int bestEffortValue, TruffleString.ErrorHandling errorHandling) {
        if (errorHandling == TruffleString.ErrorHandling.BEST_EFFORT) {
            return bestEffortValue;
        }
        assert (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE);
        return -1;
    }

    static int utf16EncodedSize(int codepoint) {
        return codepoint < 65536 ? 1 : 2;
    }

    static int utf16BrokenGetCodePointByteLength(AbstractTruffleString a, Object arrayA, int i, TruffleString.ErrorHandling errorHandling) {
        return Encodings.utf16BrokenGetCodePointByteLength(arrayA, a.offset(), a.length(), i, errorHandling);
    }

    static int utf16BrokenGetCodePointByteLength(Object arrayA, int offset, int length, int i, TruffleString.ErrorHandling errorHandling) {
        char c = TStringOps.readS1(arrayA, offset, length, i);
        if (errorHandling == TruffleString.ErrorHandling.BEST_EFFORT) {
            return Encodings.isUTF16HighSurrogate(c) && i + 1 < length && Encodings.isUTF16LowSurrogate(TStringOps.readS1(arrayA, offset, length, i + 1)) ? 4 : 2;
        }
        assert (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE);
        if (Encodings.isUTF16Surrogate(c)) {
            if (Encodings.isUTF16HighSurrogate(c)) {
                if (i + 1 == length) {
                    return -3;
                }
                if (Encodings.isUTF16LowSurrogate(TStringOps.readS1(arrayA, offset, length, i + 1))) {
                    return 4;
                }
            }
            return -1;
        }
        return 2;
    }

    static int utf16FEBrokenGetCodePointByteLength(Object arrayA, int offset, int length, int i, TruffleString.ErrorHandling errorHandling) {
        char c = Character.reverseBytes(TStringOps.readS1(arrayA, offset, length, i));
        if (errorHandling == TruffleString.ErrorHandling.BEST_EFFORT) {
            return Encodings.isUTF16HighSurrogate(c) && i + 1 < length && Encodings.isUTF16LowSurrogate(Character.reverseBytes(TStringOps.readS1(arrayA, offset, length, i + 1))) ? 4 : 2;
        }
        assert (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE);
        if (Encodings.isUTF16Surrogate(c)) {
            if (Encodings.isUTF16HighSurrogate(c)) {
                if (i + 1 == length) {
                    return -3;
                }
                if (Encodings.isUTF16LowSurrogate(Character.reverseBytes(TStringOps.readS1(arrayA, offset, length, i + 1)))) {
                    return 4;
                }
            }
            return -1;
        }
        return 2;
    }

    static byte[] utf16Encode(int codepoint) {
        byte[] bytes = new byte[codepoint < 65536 ? 2 : 4];
        Encodings.utf16Encode(codepoint, bytes, 0);
        return bytes;
    }

    static int utf16Encode(int codepoint, byte[] bytes, int index) {
        if (codepoint < 65536) {
            TStringOps.writeToByteArray(bytes, 1, index, codepoint);
            return 1;
        }
        Encodings.utf16EncodeSurrogatePair(codepoint, bytes, index);
        return 2;
    }

    static void utf16EncodeSurrogatePair(int codepoint, byte[] bytes, int index) {
        assert (codepoint > 65535);
        char c1 = Character.highSurrogate(codepoint);
        char c2 = Character.lowSurrogate(codepoint);
        TStringOps.writeToByteArray(bytes, 1, index, c1);
        TStringOps.writeToByteArray(bytes, 1, index + 1, c2);
    }

    static int utf16FEEncode(int codepoint, byte[] bytes, int index) {
        if (codepoint < 65536) {
            TStringOps.writeToByteArray(bytes, 1, index, Character.reverseBytes((char)codepoint));
            return 1;
        }
        Encodings.utf16FEEncodeSurrogatePair(codepoint, bytes, index);
        return 2;
    }

    static void utf16FEEncodeSurrogatePair(int codepoint, byte[] bytes, int index) {
        assert (codepoint > 65535);
        char c1 = Character.reverseBytes(Character.highSurrogate(codepoint));
        char c2 = Character.reverseBytes(Character.lowSurrogate(codepoint));
        TStringOps.writeToByteArray(bytes, 1, index, c1);
        TStringOps.writeToByteArray(bytes, 1, index + 1, c2);
    }

    static int utf16ValidCodePointToCharIndex(Node location, AbstractTruffleString a, Object arrayA, int codePointIndex) {
        int iCP = 0;
        int iChars = 0;
        int lengthA = a.length();
        while (CompilerDirectives.injectBranchProbability(0.75, iChars < lengthA)) {
            if ((TStringOps.readS1(a, arrayA, iChars) & 0xFC00) != 56320) {
                if (CompilerDirectives.injectBranchProbability(0.01, iCP >= codePointIndex)) break;
                ++iCP;
            }
            TStringConstants.truffleSafePointPoll(location, ++iChars);
        }
        if (iChars >= lengthA) {
            throw InternalErrors.indexOutOfBounds(lengthA, iChars);
        }
        return iChars;
    }

    static int utf16FEValidCodePointToCharIndex(Node location, Object arrayA, int offsetA, int lengthA, int codePointIndex) {
        int iCP = 0;
        int iChars = 0;
        while (CompilerDirectives.injectBranchProbability(0.75, iChars < lengthA)) {
            if ((Character.reverseBytes(TStringOps.readS1(arrayA, offsetA, lengthA, iChars)) & 0xFC00) != 56320) {
                if (CompilerDirectives.injectBranchProbability(0.01, iCP >= codePointIndex)) break;
                ++iCP;
            }
            TStringConstants.truffleSafePointPoll(location, ++iChars);
        }
        if (iChars >= lengthA) {
            throw InternalErrors.indexOutOfBounds(lengthA, iChars);
        }
        return iChars;
    }

    static int utf16BrokenCodePointToCharIndex(Node location, AbstractTruffleString a, Object arrayA, int codePointIndex) {
        int iCP = 0;
        int iChars = 0;
        int lengthA = a.length();
        while (iCP < codePointIndex) {
            if (Encodings.isUTF16HighSurrogate(TStringOps.readS1(a, arrayA, iChars)) && iChars + 1 < lengthA && Encodings.isUTF16LowSurrogate(TStringOps.readS1(a, arrayA, iChars + 1))) {
                ++iChars;
            }
            ++iChars;
            TStringConstants.truffleSafePointPoll(location, ++iCP);
        }
        if (iChars >= lengthA) {
            throw InternalErrors.indexOutOfBounds(lengthA, iChars);
        }
        return iChars;
    }

    static int utf16FEBrokenCodePointToCharIndex(Node location, Object arrayA, int offsetA, int lengthA, int codePointIndex) {
        int iCP = 0;
        int iChars = 0;
        while (iCP < codePointIndex) {
            if (Encodings.isUTF16HighSurrogate(Character.reverseBytes(TStringOps.readS1(arrayA, offsetA, lengthA, iChars))) && iChars + 1 < lengthA && Encodings.isUTF16LowSurrogate(Character.reverseBytes(TStringOps.readS1(arrayA, offsetA, lengthA, iChars + 1)))) {
                ++iChars;
            }
            ++iChars;
            TStringConstants.truffleSafePointPoll(location, ++iCP);
        }
        if (iChars >= lengthA) {
            throw InternalErrors.indexOutOfBounds(lengthA, iChars);
        }
        return iChars;
    }

    static int utf16DecodeValid(AbstractTruffleString a, Object arrayA, int i) {
        return Encodings.utf16DecodeValid(arrayA, a.offset(), a.length(), i);
    }

    static int utf16DecodeValid(Object arrayA, int offsetA, int lengthA, int i) {
        char c = TStringOps.readS1(arrayA, offsetA, lengthA, i);
        if (Encodings.isUTF16HighSurrogate(c)) {
            assert (i + 1 < lengthA);
            assert (Encodings.isUTF16LowSurrogate(TStringOps.readS1(arrayA, offsetA, lengthA, i + 1)));
            return Character.toCodePoint(c, TStringOps.readS1(arrayA, offsetA, lengthA, i + 1));
        }
        return c;
    }

    static int utf16FEDecodeValid(Object arrayA, int offsetA, int lengthA, int i) {
        char c = Character.reverseBytes(TStringOps.readS1(arrayA, offsetA, lengthA, i));
        if (Encodings.isUTF16HighSurrogate(c)) {
            assert (i + 1 < lengthA);
            assert (Encodings.isUTF16LowSurrogate(Character.reverseBytes(TStringOps.readS1(arrayA, offsetA, lengthA, i + 1))));
            return Character.toCodePoint(c, Character.reverseBytes(TStringOps.readS1(arrayA, offsetA, lengthA, i + 1)));
        }
        return c;
    }

    static int utf16DecodeBroken(AbstractTruffleString a, Object arrayA, int i, TruffleString.ErrorHandling errorHandling) {
        return Encodings.utf16DecodeBroken(arrayA, a.offset(), a.length(), i, errorHandling);
    }

    static int utf16DecodeBroken(Object arrayA, int offsetA, int lengthA, int i, TruffleString.ErrorHandling errorHandling) {
        char c = TStringOps.readS1(arrayA, offsetA, lengthA, i);
        if (errorHandling == TruffleString.ErrorHandling.BEST_EFFORT) {
            char c2;
            if (Encodings.isUTF16HighSurrogate(c) && i + 1 < lengthA && Encodings.isUTF16LowSurrogate(c2 = TStringOps.readS1(arrayA, offsetA, lengthA, i + 1))) {
                return Character.toCodePoint(c, c2);
            }
        } else {
            assert (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE);
            if (Encodings.isUTF16Surrogate(c)) {
                if (Encodings.isUTF16LowSurrogate(c) || i + 1 >= lengthA) {
                    return -1;
                }
                char c2 = TStringOps.readS1(arrayA, offsetA, lengthA, i + 1);
                if (!Encodings.isUTF16LowSurrogate(c2)) {
                    return -1;
                }
                return Character.toCodePoint(c, c2);
            }
        }
        return c;
    }

    static int utf16FEDecodeBroken(Object arrayA, int offsetA, int lengthA, int i, TruffleString.ErrorHandling errorHandling) {
        char c = Character.reverseBytes(TStringOps.readS1(arrayA, offsetA, lengthA, i));
        if (errorHandling == TruffleString.ErrorHandling.BEST_EFFORT) {
            char c2;
            if (Encodings.isUTF16HighSurrogate(c) && i + 1 < lengthA && Encodings.isUTF16LowSurrogate(c2 = Character.reverseBytes(TStringOps.readS1(arrayA, offsetA, lengthA, i + 1)))) {
                return Character.toCodePoint(c, c2);
            }
        } else {
            assert (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE);
            if (Encodings.isUTF16Surrogate(c)) {
                if (Encodings.isUTF16LowSurrogate(c) || i + 1 >= lengthA) {
                    return -1;
                }
                char c2 = Character.reverseBytes(TStringOps.readS1(arrayA, offsetA, lengthA, i + 1));
                if (!Encodings.isUTF16LowSurrogate(c2)) {
                    return -1;
                }
                return Character.toCodePoint(c, c2);
            }
        }
        return c;
    }

    static boolean isValidUnicodeCodepoint(int codepoint) {
        return !Encodings.isUTF16Surrogate(codepoint) && Integer.toUnsignedLong(codepoint) <= 0x10FFFFL;
    }

    static int maxCodePoint(TruffleString.Encoding encoding) {
        switch (encoding) {
            case US_ASCII: {
                return 127;
            }
            case ISO_8859_1: 
            case BYTES: {
                return 255;
            }
            case UTF_8: 
            case UTF_16BE: 
            case UTF_16LE: 
            case UTF_32BE: 
            case UTF_32LE: {
                return 0x10FFFF;
            }
        }
        return Integer.MAX_VALUE;
    }

    static final class BuiltinTranscodingErrorHandler
    implements TranscodingErrorHandler {
        BuiltinTranscodingErrorHandler() {
        }

        @Override
        public TranscodingErrorHandler.ReplacementString apply(AbstractTruffleString sourceString, int byteIndex, int estimatedByteLength, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    static final class BuiltinDecodingErrorHandler
    implements DecodingErrorHandler {
        BuiltinDecodingErrorHandler() {
        }

        @Override
        public DecodingErrorHandler.Result apply(AbstractTruffleString string, int bytePosition, int estimatedByteLength) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }
}

