/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import com.microsoft.azure.storage.LocationMode;
import io.crate.common.unit.TimeValue;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class AzureStorageSettings {
    private final String account;
    private final String connectString;
    private final String endpoint;
    private final String secondaryEndpoint;
    private final String endpointSuffix;
    private final TimeValue timeout;
    private final int maxRetries;
    private final Proxy proxy;
    private final LocationMode locationMode;

    @VisibleForTesting
    AzureStorageSettings(String account, String connectString, String endpoint, String secondaryEndpoint, String endpointSuffix, TimeValue timeout, int maxRetries, Proxy proxy, LocationMode locationMode) {
        this.account = account;
        this.connectString = connectString;
        this.endpoint = endpoint;
        this.secondaryEndpoint = secondaryEndpoint;
        this.endpointSuffix = endpointSuffix;
        this.timeout = timeout;
        this.maxRetries = maxRetries;
        this.proxy = proxy;
        this.locationMode = locationMode;
    }

    private AzureStorageSettings(String account, String key, String sasToken, LocationMode locationMode, String endpoint, String secondaryEndpoint, String endpointSuffix, TimeValue timeout, int maxRetries, Proxy.Type proxyType, String proxyHost, Integer proxyPort) {
        boolean hasEndpointSuffix = Strings.hasText((CharSequence)endpointSuffix);
        boolean hasEndpoint = Strings.hasText((CharSequence)endpoint);
        boolean hasSecondaryEndpoint = Strings.hasText((CharSequence)secondaryEndpoint);
        if (hasEndpoint && hasEndpointSuffix) {
            throw new SettingsException("Cannot specify both endpoint and endpoint_suffix parameters");
        }
        if (hasSecondaryEndpoint && !hasEndpoint) {
            throw new SettingsException("Cannot specify secondary_endpoint without specifying endpoint");
        }
        this.account = account;
        this.connectString = this.buildConnectString(account, key, sasToken, endpoint, endpointSuffix, secondaryEndpoint);
        this.endpoint = endpoint;
        this.secondaryEndpoint = secondaryEndpoint;
        this.endpointSuffix = endpointSuffix;
        this.timeout = timeout;
        this.maxRetries = maxRetries;
        if (proxyType.equals((Object)Proxy.Type.DIRECT) && (proxyPort != 0 || Strings.hasText((CharSequence)proxyHost))) {
            throw new SettingsException("Azure Proxy port or host have been set but proxy type is not defined.");
        }
        if (!proxyType.equals((Object)Proxy.Type.DIRECT) && (proxyPort == 0 || Strings.isNullOrEmpty((CharSequence)proxyHost))) {
            throw new SettingsException("Azure Proxy type has been set but proxy host or port is not defined.");
        }
        if (proxyType.equals((Object)Proxy.Type.DIRECT)) {
            this.proxy = null;
        } else {
            try {
                this.proxy = new Proxy(proxyType, new InetSocketAddress(InetAddress.getByName(proxyHost), (int)proxyPort));
            }
            catch (UnknownHostException e) {
                throw new SettingsException("Azure proxy host is unknown.", (Throwable)e);
            }
        }
        this.locationMode = locationMode;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getConnectString() {
        return this.connectString;
    }

    public LocationMode getLocationMode() {
        return this.locationMode;
    }

    private String buildConnectString(String account, @Nullable String key, @Nullable String sasToken, String endpoint, String endpointSuffix, String secondaryEndpoint) {
        boolean hasSasToken = Strings.hasText((CharSequence)sasToken);
        boolean hasKey = Strings.hasText((CharSequence)key);
        if (!hasSasToken && !hasKey) {
            throw new SettingsException("Neither a secret key nor a shared access token was set.");
        }
        if (hasSasToken && hasKey) {
            throw new SettingsException("Both a secret as well as a shared access token were set.");
        }
        StringBuilder connectionStringBuilder = new StringBuilder();
        connectionStringBuilder.append("DefaultEndpointsProtocol=https").append(";AccountName=").append(account);
        if (hasKey) {
            connectionStringBuilder.append(";AccountKey=").append(key);
        } else {
            connectionStringBuilder.append(";SharedAccessSignature=").append(sasToken);
        }
        if (Strings.hasText((CharSequence)endpointSuffix)) {
            connectionStringBuilder.append(";EndpointSuffix=").append(endpointSuffix);
        }
        if (Strings.hasText((CharSequence)endpoint)) {
            connectionStringBuilder.append(";BlobEndpoint=").append(endpoint);
        }
        if (Strings.hasText((CharSequence)secondaryEndpoint)) {
            connectionStringBuilder.append(";BlobSecondaryEndpoint=").append(secondaryEndpoint);
        }
        return connectionStringBuilder.toString();
    }

    /*
     * Exception decompiling
     */
    static AzureStorageSettings getClientSettings(Settings settings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <T> T getConfigValue(Settings settings, Setting<T> clientSetting) {
        return (T)clientSetting.get(settings);
    }

    static AzureStorageSettings copy(AzureStorageSettings settings) {
        return new AzureStorageSettings(settings.account, settings.connectString, settings.endpoint, settings.secondaryEndpoint, settings.endpointSuffix, settings.timeout, settings.maxRetries, settings.proxy, settings.locationMode);
    }

    public String toString() {
        return "AzureStorageSettings{account='" + this.account + "', timeout=" + String.valueOf(this.timeout) + ", endpoint='" + this.endpoint + "', secondaryEndpoint='" + this.secondaryEndpoint + "', endpointSuffix='" + this.endpointSuffix + "', maxRetries=" + this.maxRetries + ", proxy=" + String.valueOf(this.proxy) + ", locationMode='" + String.valueOf(this.locationMode) + "'}";
    }
}

