/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.ColumnConstraint;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.TableElement;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class AddColumnDefinition<T>
extends TableElement<T> {
    private final T name;
    @Nullable
    private final ColumnType<T> type;
    private final List<ColumnConstraint<T>> constraints;

    public AddColumnDefinition(T name, @Nullable ColumnType<T> type, List<ColumnConstraint<T>> constraints) {
        this.name = name;
        this.type = type;
        this.constraints = constraints;
        ColumnDefinition.validateColumnConstraints(name.toString(), type, constraints);
    }

    public T name() {
        return this.name;
    }

    @Nullable
    public ColumnType<T> type() {
        return this.type;
    }

    public List<ColumnConstraint<T>> constraints() {
        return this.constraints;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddColumnDefinition that = (AddColumnDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.constraints, that.constraints);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.type, this.constraints);
    }

    @Override
    public String toString() {
        return "AddColumnDefinition{name=" + String.valueOf(this.name) + ", type=" + String.valueOf(this.type) + ", constraints=" + String.valueOf(this.constraints) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAddColumnDefinition(this, context);
    }

    @Override
    public void visit(Consumer<? super T> consumer) {
        consumer.accept(this.name);
        for (ColumnConstraint<T> constraint : this.constraints) {
            constraint.visit(consumer);
        }
    }
}

