/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.common.Booleans;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public enum ColumnPolicy {
    DYNAMIC{

        @Override
        public String toMappingValue() {
            return "true";
        }
    }
    ,
    STRICT{

        @Override
        public String toMappingValue() {
            return "strict";
        }
    }
    ,
    IGNORED{

        @Override
        public String toMappingValue() {
            return "false";
        }
    };

    public static final List<ColumnPolicy> VALUES;
    public static final String MAPPING_KEY = "dynamic";

    public String lowerCaseName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public abstract String toMappingValue();

    public static ColumnPolicy fromMappingValue(@Nullable Object value) {
        if (value == null) {
            return DYNAMIC;
        }
        String str = value.toString();
        if (Booleans.isTrue((String)str)) {
            return DYNAMIC;
        }
        if (Booleans.isFalse((String)str)) {
            return IGNORED;
        }
        if (str.equalsIgnoreCase("strict")) {
            return STRICT;
        }
        throw new IllegalArgumentException("Invalid column policy: " + String.valueOf(value));
    }

    public static ColumnPolicy of(String value) {
        switch (value.toLowerCase(Locale.ENGLISH)) {
            case "dynamic": {
                return DYNAMIC;
            }
            case "strict": {
                return STRICT;
            }
            case "ignored": {
                return IGNORED;
            }
        }
        throw new IllegalArgumentException("Invalid column policy: " + value + " use one of [dynamic, strict, ignored]");
    }

    public String toString() {
        return this.lowerCaseName();
    }

    static {
        VALUES = List.of(ColumnPolicy.values());
    }
}

