/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.Table;
import java.util.Objects;

public class DropTable<T>
extends Statement {
    private final Table<T> table;
    private final boolean dropIfExists;

    public DropTable(Table<T> table, boolean dropIfExists) {
        this.table = table;
        this.dropIfExists = dropIfExists;
    }

    public boolean dropIfExists() {
        return this.dropIfExists;
    }

    public Table<T> table() {
        return this.table;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropTable(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropTable dropTable = (DropTable)o;
        return this.dropIfExists == dropTable.dropIfExists && Objects.equals(this.table, dropTable.table);
    }

    @Override
    public String toString() {
        return "DropTable{table=" + String.valueOf(this.table) + ", dropIfExists=" + this.dropIfExists + "}";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.dropIfExists);
    }
}

