/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Relation;
import io.crate.sql.tree.SetOperation;
import java.util.Objects;

public class Intersect
extends SetOperation {
    private final Relation left;
    private final Relation right;

    public Intersect(Relation left, Relation right) {
        this.left = Objects.requireNonNull(left, "relation must not be null");
        this.right = Objects.requireNonNull(right, "relation must not be null");
    }

    public Relation getLeft() {
        return this.left;
    }

    public Relation getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIntersect(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Intersect intersect = (Intersect)o;
        return Objects.equals(this.left, intersect.left) && Objects.equals(this.right, intersect.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    @Override
    public String toString() {
        return "Intersect{left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + "}";
    }
}

