/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.Table;
import java.util.List;
import java.util.Objects;

public class RestoreSnapshot<T>
extends Statement {
    private final QualifiedName name;
    private final GenericProperties<T> properties;
    private final Mode mode;
    private final List<String> types;
    private final List<Table<T>> tables;

    public RestoreSnapshot(QualifiedName name, Mode mode, GenericProperties<T> properties) {
        this(name, mode, properties, List.of(), List.of());
    }

    public RestoreSnapshot(QualifiedName name, Mode mode, GenericProperties<T> properties, List<String> types) {
        this(name, mode, properties, types, List.of());
    }

    public RestoreSnapshot(QualifiedName name, Mode mode, GenericProperties<T> properties, List<String> types, List<Table<T>> tables) {
        this.name = name;
        this.mode = mode;
        this.types = types;
        this.tables = tables;
        this.properties = properties;
    }

    public QualifiedName name() {
        return this.name;
    }

    public GenericProperties<T> properties() {
        return this.properties;
    }

    public Mode mode() {
        return this.mode;
    }

    public List<String> types() {
        return this.types;
    }

    public List<Table<T>> tables() {
        return this.tables;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreSnapshot that = (RestoreSnapshot)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.properties, that.properties) && Objects.equals(this.tables, that.tables);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.properties, this.tables);
    }

    @Override
    public String toString() {
        return "RestoreSnapshot{name=" + String.valueOf(this.name) + ", properties=" + String.valueOf(this.properties) + ", tables=" + String.valueOf(this.tables) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRestoreSnapshot(this, context);
    }

    public static enum Mode {
        ALL,
        TABLE,
        METADATA,
        CUSTOM;

    }
}

