/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Statement;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class ShowColumns
extends Statement {
    private final QualifiedName table;
    @Nullable
    private final QualifiedName schema;
    @Nullable
    private final String likePattern;
    private final Optional<Expression> where;

    public ShowColumns(QualifiedName table, @Nullable QualifiedName schema, Optional<Expression> where, @Nullable String likePattern) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.schema = schema;
        this.likePattern = likePattern;
        this.where = where;
    }

    public QualifiedName table() {
        return this.table;
    }

    @Nullable
    public QualifiedName schema() {
        return this.schema;
    }

    @Nullable
    public String likePattern() {
        return this.likePattern;
    }

    public Optional<Expression> where() {
        return this.where;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowColumns(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShowColumns that = (ShowColumns)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.schema, that.schema) && Objects.equals(this.likePattern, that.likePattern) && Objects.equals(this.where, that.where);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.schema, this.likePattern, this.where);
    }

    @Override
    public String toString() {
        return "ShowColumns{table=" + String.valueOf(this.table) + ", schema=" + String.valueOf(this.schema) + ", pattern='" + this.likePattern + "', where=" + String.valueOf(this.where) + "}";
    }
}

