/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.FrameBound;
import io.crate.sql.tree.Node;
import java.util.Optional;

public class WindowFrame
extends Node {
    private final Mode mode;
    private final FrameBound start;
    private final Optional<FrameBound> end;

    public WindowFrame(Mode mode, FrameBound start, Optional<FrameBound> end) {
        this.mode = mode;
        this.start = start;
        this.end = end;
    }

    public Mode mode() {
        return this.mode;
    }

    public FrameBound getStart() {
        return this.start;
    }

    public Optional<FrameBound> getEnd() {
        return this.end;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof WindowFrame)) return false;
        WindowFrame that = (WindowFrame)o;
        if (this.mode != that.mode) return false;
        if (!this.start.equals(that.start)) return false;
        if (!this.end.equals(that.end)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int result = this.mode.hashCode();
        result = 31 * result + this.start.hashCode();
        result = 31 * result + this.end.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "WindowFrame{frameType=" + String.valueOf((Object)this.mode) + ", start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindowFrame(this, context);
    }

    public static enum Mode {
        RANGE,
        ROWS;

    }
}

