/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.common.exceptions.Exceptions;
import io.crate.data.AsyncFlatMapper;
import io.crate.data.BatchIterator;
import io.crate.data.CloseableIterator;
import java.util.concurrent.CompletionStage;

public final class AsyncFlatMapBatchIterator<I, O>
implements BatchIterator<O> {
    private final BatchIterator<I> source;
    private final AsyncFlatMapper<I, O> mapper;
    private NextAction nextAction = NextAction.SOURCE;
    private O current = null;
    private CloseableIterator<O> mappedElements;
    private boolean sourceExhausted = false;

    public AsyncFlatMapBatchIterator(BatchIterator<I> source, AsyncFlatMapper<I, O> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    public void kill(Throwable throwable) {
        this.source.kill(throwable);
    }

    @Override
    public O currentElement() {
        return this.current;
    }

    @Override
    public void moveToStart() {
        this.source.moveToStart();
        this.sourceExhausted = false;
        this.mappedElements = null;
        this.nextAction = NextAction.SOURCE;
        this.current = null;
    }

    @Override
    public boolean moveNext() {
        while (true) {
            if (this.nextAction == NextAction.SOURCE) {
                if (this.source.moveNext()) {
                    this.nextAction = NextAction.MAPPER;
                } else {
                    this.sourceExhausted = this.source.allLoaded();
                }
                return false;
            }
            if (this.mappedElements == null) {
                return false;
            }
            if (this.mappedElements.hasNext()) {
                this.current = this.mappedElements.next();
                return true;
            }
            this.mappedElements.close();
            this.mappedElements = null;
            this.nextAction = NextAction.SOURCE;
        }
    }

    @Override
    public void close() {
        if (this.mappedElements != null) {
            this.mappedElements.close();
            this.mappedElements = null;
        }
        this.source.close();
        try {
            this.mapper.close();
        }
        catch (Exception e) {
            throw Exceptions.toRuntimeException((Throwable)e);
        }
    }

    @Override
    public CompletionStage<?> loadNextBatch() throws Exception {
        if (this.nextAction == NextAction.SOURCE) {
            return this.source.loadNextBatch();
        }
        return this.mapper.apply(this.source.currentElement(), this.sourceExhausted).thenAccept(rows -> {
            this.mappedElements = rows;
        });
    }

    @Override
    public boolean allLoaded() {
        return this.source.allLoaded() && this.nextAction == NextAction.SOURCE;
    }

    @Override
    public boolean hasLazyResultSet() {
        return true;
    }

    private static enum NextAction {
        SOURCE,
        MAPPER;

    }
}

