/*
 * Decompiled with CFR 0.152.
 */
package io.crate.copy.s3.common;

import java.net.URI;
import java.util.Objects;
import org.jetbrains.annotations.VisibleForTesting;

public class S3URI {
    private static final String INVALID_URI_MSG = "Invalid URI. Please make sure that given URI is encoded properly.";
    private final URI uri;
    private final String accessKey;
    private final String secretKey;
    private final String bucket;
    private final String key;
    private final String endpoint;

    private S3URI(URI uri, String accessKey, String secretKey, String bucket, String key, String endpoint) {
        this.uri = uri;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.bucket = bucket;
        this.key = key;
        this.endpoint = endpoint;
    }

    public static S3URI toS3URI(URI uri) {
        String key;
        String bucket;
        String path;
        int splitIndex;
        URI normalizedURI = S3URI.normalize(uri);
        String userInfo = S3URI.getUserInfo(normalizedURI);
        String accessKey = null;
        String secretKey = null;
        if (userInfo != null) {
            String[] userInfoParts = userInfo.split(":");
            try {
                accessKey = userInfoParts[0];
                secretKey = userInfoParts[1];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        } else if (normalizedURI.toString().contains("@") && normalizedURI.toString().contains(":")) {
            throw new IllegalArgumentException(INVALID_URI_MSG);
        }
        if ((splitIndex = (path = normalizedURI.getPath().substring(1)).indexOf(47)) == -1) {
            bucket = path;
            key = "";
        } else {
            bucket = path.substring(0, splitIndex);
            key = path.substring(splitIndex + 1);
        }
        String endpoint = null;
        if (normalizedURI.getHost() != null) {
            endpoint = normalizedURI.getHost() + ":" + normalizedURI.getPort();
        }
        return new S3URI(normalizedURI, accessKey, secretKey, bucket, key, endpoint);
    }

    @VisibleForTesting
    static String getUserInfo(URI uri) {
        String userInfo = null;
        if (uri.getHost() == null && uri.getPort() == -1 && uri.getUserInfo() == null) {
            String authority = uri.getAuthority();
            if (authority != null) {
                int idx = authority.indexOf(64);
                if (idx != authority.length() - 1) {
                    throw new IllegalArgumentException(INVALID_URI_MSG);
                }
                userInfo = uri.getAuthority().substring(0, idx);
            }
        } else {
            userInfo = uri.getUserInfo();
        }
        return userInfo;
    }

    private static URI normalize(URI uri) {
        assert ("s3".equals(uri.getScheme()));
        if (uri.getHost() != null && (uri.getPath() == null || uri.getPort() == -1)) {
            return URI.create("s3://" + (String)(uri.getRawUserInfo() == null ? "" : uri.getRawUserInfo() + "@") + "/" + uri.getHost() + uri.getPath());
        }
        return uri;
    }

    public S3URI replacePath(String bucket, String key) {
        StringBuilder sb = new StringBuilder();
        sb.append("s3://");
        if (this.uri.getRawAuthority() != null) {
            sb.append(this.uri.getRawAuthority());
        }
        sb.append("/").append(bucket).append("/").append(key);
        return new S3URI(URI.create(sb.toString()), this.accessKey, this.secretKey, bucket, key, this.endpoint);
    }

    public String toString() {
        return this.uri.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof S3URI)) {
            return false;
        }
        S3URI that = (S3URI)obj;
        return this.uri.equals(that.uri) && Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.secretKey, that.secretKey) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.key, that.key) && Objects.equals(this.endpoint, that.endpoint);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.accessKey, this.secretKey, this.bucket, this.key, this.endpoint);
    }

    public URI uri() {
        return this.uri;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String accessKey() {
        return this.accessKey;
    }

    public String secretKey() {
        return this.secretKey;
    }

    public String endpoint() {
        return this.endpoint;
    }
}

