/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common;

public class Hex {
    public static final String HEX_FLAG = "\\x";
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean isHexFormat(String data) {
        return data.startsWith(HEX_FLAG);
    }

    public static String stripHexFormatFlag(String data) {
        if (data.length() < 2) {
            throw new IllegalArgumentException("Invalid hex formatted string");
        }
        return Hex.validateHex(data.substring(2), 2);
    }

    public static String validateHex(String data, int offset) {
        if ((data.length() & 1) != 0) {
            throw new IllegalStateException("Odd number of characters");
        }
        for (int i = 0; i < data.length(); ++i) {
            Hex.toDigit(data.charAt(i), offset + i);
        }
        return data;
    }

    public static char[] encodeHex(byte[] data) {
        return Hex.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return Hex.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexString(byte[] data) {
        return new String(Hex.encodeHex(data));
    }

    public static byte[] decodeHex(String data) throws IllegalStateException {
        return Hex.decodeHex(data.toCharArray());
    }

    public static byte[] decodeHex(char[] data) throws IllegalStateException {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalStateException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Hex.toDigit(data[j], j) << 4;
            f |= Hex.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) throws IllegalStateException {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalStateException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

