/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import org.jetbrains.annotations.Nullable;

public final class CartesianList<E>
extends AbstractList<List<E>>
implements RandomAccess {
    private final transient List<List<E>> axes;
    private final transient int[] axesSizeProduct;

    public static <E> List<List<E>> of(List<? extends List<? extends E>> lists) {
        ArrayList<List<List<? extends E>>> axes = new ArrayList<List<List<? extends E>>>(lists.size());
        for (List<E> list : lists) {
            if (list.isEmpty()) {
                return List.of();
            }
            axes.add(List.copyOf(list));
        }
        return new CartesianList<E>(axes);
    }

    CartesianList(List<List<E>> axes) {
        this.axes = axes;
        int[] axesSizeProduct = new int[axes.size() + 1];
        axesSizeProduct[axes.size()] = 1;
        for (int i = axes.size() - 1; i >= 0; --i) {
            long result = (long)axesSizeProduct[i + 1] * (long)axes.get(i).size();
            assert (result == (long)((int)result)) : "Cartesian product too large; must have size at most Integer.MAX_VALUE";
            axesSizeProduct[i] = (int)result;
        }
        this.axesSizeProduct = axesSizeProduct;
    }

    private int getAxisIndexForProductIndex(int index, int axis) {
        return index / this.axesSizeProduct[axis + 1] % this.axes.get(axis).size();
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof List)) {
            return -1;
        }
        List list = (List)o;
        if (list.size() != this.axes.size()) {
            return -1;
        }
        ListIterator itr = list.listIterator();
        int computedIndex = 0;
        while (itr.hasNext()) {
            int axisIndex = itr.nextIndex();
            int elemIndex = this.axes.get(axisIndex).indexOf(itr.next());
            if (elemIndex == -1) {
                return -1;
            }
            computedIndex += elemIndex * this.axesSizeProduct[axisIndex + 1];
        }
        return computedIndex;
    }

    @Override
    public List<E> get(final int index) {
        Objects.checkIndex(index, this.size());
        return new AbstractList<E>(this){
            final /* synthetic */ CartesianList this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int size() {
                return this.this$0.axes.size();
            }

            @Override
            public E get(int axis) {
                Objects.checkIndex(axis, this.size());
                int axisIndex = this.this$0.getAxisIndexForProductIndex(index, axis);
                return this.this$0.axes.get(axis).get(axisIndex);
            }
        };
    }

    @Override
    public int size() {
        return this.axesSizeProduct[0];
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.indexOf(o) != -1;
    }
}

