/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedAlterTable;
import io.crate.analyze.AnalyzedAlterTableOpenClose;
import io.crate.analyze.AnalyzedAlterTableRenameTable;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.AlterTable;
import io.crate.sql.tree.AlterTableOpenClose;
import io.crate.sql.tree.AlterTableRenameTable;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Table;
import java.util.List;

class AlterTableAnalyzer {
    private final Schemas schemas;
    private final NodeContext nodeCtx;

    AlterTableAnalyzer(Schemas schemas, NodeContext nodeCtx) {
        this.schemas = schemas;
        this.nodeCtx = nodeCtx;
    }

    AnalyzedAlterTable analyze(AlterTable<Expression> node, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.TO_LITERAL_VALIDATE_NAME, null);
        CoordinatorSessionSettings sessionSettings = txnCtx.sessionSettings();
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(sessionSettings);
        AlterTable alterTable = node.map(x -> exprAnalyzerWithFieldsAsString.convert((Expression)x, exprCtx));
        TableInfo TableInfo2 = (TableInfo)this.schemas.findRelation(alterTable.table().getName(), Operation.ALTER_BLOCKS, sessionSettings.sessionUser(), sessionSettings.searchPath());
        return new AnalyzedAlterTable(TableInfo2, (AlterTable<Symbol>)alterTable);
    }

    AnalyzedAlterTableRenameTable analyze(AlterTableRenameTable<Expression> node, CoordinatorSessionSettings sessionSettings) {
        DocTableInfo docTable;
        if (!node.table().partitionProperties().isEmpty()) {
            throw new UnsupportedOperationException("Renaming a single partition is not supported");
        }
        List newIdentParts = node.newName().getParts();
        if (newIdentParts.size() > 1) {
            throw new IllegalArgumentException("Target table name must not include a schema");
        }
        QualifiedName qName = node.blob() ? RelationName.fromBlobTable(node.table()).toQualifiedName() : node.table().getName();
        Object source = this.schemas.findRelation(qName, Operation.ALTER_TABLE_RENAME, sessionSettings.sessionUser(), sessionSettings.searchPath());
        RelationName sourceName = source.ident();
        RelationName targetName = new RelationName(sourceName.schema(), (String)newIdentParts.get(0));
        targetName.ensureValidForRelationCreation();
        boolean isPartitioned = source instanceof DocTableInfo && (docTable = (DocTableInfo)source).isPartitioned();
        return new AnalyzedAlterTableRenameTable(sourceName, targetName, isPartitioned);
    }

    public AnalyzedAlterTableOpenClose analyze(AlterTableOpenClose<Expression> node, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        ExpressionAnalyzer exprAnalyzerWithFieldsAsStrings = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.TO_LITERAL_VALIDATE_NAME, null);
        CoordinatorSessionSettings sessionSettings = txnCtx.sessionSettings();
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(sessionSettings);
        Table table = node.table().map(x -> exprAnalyzerWithFieldsAsStrings.convert((Expression)x, exprCtx));
        QualifiedName qName = node.blob() ? RelationName.fromBlobTable(node.table()).toQualifiedName() : node.table().getName();
        Operation operation = node.openTable() ? Operation.ALTER_OPEN : Operation.ALTER_CLOSE;
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.findRelation(qName, operation, sessionSettings.sessionUser(), sessionSettings.searchPath());
        return new AnalyzedAlterTableOpenClose(tableInfo, (Table<Symbol>)table, node.openTable());
    }
}

