/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedAlterTableDropColumn;
import io.crate.analyze.DropColumn;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.NameFieldProvider;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.IndexReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.AlterTableDropColumn;
import io.crate.sql.tree.DropColumnDefinition;
import io.crate.sql.tree.Expression;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AlterTableDropColumnAnalyzer {
    private final Schemas schemas;
    private final NodeContext nodeCtx;

    AlterTableDropColumnAnalyzer(Schemas schemas, NodeContext nodeCtx) {
        this.schemas = schemas;
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedAlterTableDropColumn analyze(AlterTableDropColumn<Expression> alterTable, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        if (!alterTable.table().partitionProperties().isEmpty()) {
            throw new UnsupportedOperationException("Dropping a column from a single partition is not supported");
        }
        CoordinatorSessionSettings sessionSettings = txnCtx.sessionSettings();
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.findRelation(alterTable.table().getName(), Operation.ALTER, sessionSettings.sessionUser(), sessionSettings.searchPath());
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, new NameFieldProvider(new DocTableRelation(tableInfo)), null);
        ExpressionAnalysisContext expressionContext = new ExpressionAnalysisContext(sessionSettings);
        ArrayList<DropColumn> dropColumns = new ArrayList<DropColumn>(alterTable.tableElements().size());
        for (DropColumnDefinition dropColumnDefinition : alterTable.tableElements()) {
            Expression name = (Expression)dropColumnDefinition.name();
            try {
                Reference colRefToDrop = (Reference)expressionAnalyzer.convert(name, expressionContext);
                dropColumns.add(new DropColumn(colRefToDrop, dropColumnDefinition.ifExists()));
            }
            catch (ColumnUnknownException e) {
                if (dropColumnDefinition.ifExists()) continue;
                throw e;
            }
        }
        AlterTableDropColumnAnalyzer.validateStatic(tableInfo, dropColumns);
        tableInfo.dropColumns(dropColumns);
        return new AnalyzedAlterTableDropColumn(tableInfo, dropColumns);
    }

    private static void validateStatic(DocTableInfo tableInfo, List<DropColumn> dropColumns) {
        if (tableInfo.versionCreated().before(DocTableInfo.COLUMN_OID_VERSION)) {
            throw new UnsupportedOperationException("Dropping columns of a table created before version 5.5 is not supported");
        }
        HashSet<ColumnIdent> uniqueSet = new HashSet<ColumnIdent>(dropColumns.size());
        for (int i = 0; i < dropColumns.size(); ++i) {
            IndexReference indexRef;
            Reference refToDrop = dropColumns.get(i).ref();
            ColumnIdent colToDrop = refToDrop.column();
            if (uniqueSet.contains(colToDrop)) {
                throw new IllegalArgumentException("Column \"" + colToDrop.sqlFqn() + "\" specified more than once");
            }
            uniqueSet.add(colToDrop);
            if (colToDrop.isSystemColumn()) {
                throw new IllegalArgumentException("Dropping a system column is not allowed");
            }
            if (refToDrop instanceof IndexReference && !(indexRef = (IndexReference)refToDrop).columns().isEmpty()) {
                throw new UnsupportedOperationException("Dropping INDEX column '" + colToDrop.fqn() + "' is not supported");
            }
            if (tableInfo.primaryKey().contains(colToDrop)) {
                throw new UnsupportedOperationException("Dropping column: " + colToDrop.sqlFqn() + " which is part of the PRIMARY KEY is not allowed");
            }
            if (tableInfo.clusteredBy().equals(colToDrop)) {
                throw new UnsupportedOperationException("Dropping column: " + colToDrop.sqlFqn() + " which is used in 'CLUSTERED BY' is not allowed");
            }
            if (!tableInfo.isPartitioned() || !tableInfo.partitionedBy().contains(colToDrop)) continue;
            throw new UnsupportedOperationException("Dropping column: " + colToDrop.sqlFqn() + " which is part of the 'PARTITIONED BY' columns is not allowed");
        }
    }
}

