/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.WhereClause;
import io.crate.execution.dsl.projection.WriterProjection;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.doc.DocTableInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class BoundCopyTo {
    private final List<Symbol> outputs;
    private final DocTableInfo table;
    private final WhereClause whereClause;
    private final Symbol uri;
    private final boolean columnsDefined;
    @Nullable
    private final WriterProjection.CompressionType compressionType;
    @Nullable
    private final WriterProjection.OutputFormat outputFormat;
    @Nullable
    private final List<String> outputNames;
    private final Map<ColumnIdent, Symbol> overwrites;
    private final Settings withClauseOptions;

    public BoundCopyTo(List<Symbol> outputs, DocTableInfo table, WhereClause whereClause, Symbol uri, @Nullable WriterProjection.CompressionType compressionType, @Nullable WriterProjection.OutputFormat outputFormat, @Nullable List<String> outputNames, boolean columnsDefined, @Nullable Map<ColumnIdent, Symbol> overwrites, Settings withClauseOptions) {
        this.outputs = outputs;
        this.table = table;
        this.whereClause = whereClause;
        this.uri = uri;
        this.columnsDefined = columnsDefined;
        this.compressionType = compressionType;
        this.outputNames = outputNames;
        this.outputFormat = outputFormat;
        this.overwrites = Objects.requireNonNullElse(overwrites, Map.of());
        this.withClauseOptions = withClauseOptions;
    }

    public List<Symbol> outputs() {
        return this.outputs;
    }

    public DocTableInfo table() {
        return this.table;
    }

    public WhereClause whereClause() {
        return this.whereClause;
    }

    public Symbol uri() {
        return this.uri;
    }

    public boolean columnsDefined() {
        return this.columnsDefined;
    }

    @Nullable
    public WriterProjection.CompressionType compressionType() {
        return this.compressionType;
    }

    @Nullable
    public WriterProjection.OutputFormat outputFormat() {
        return this.outputFormat;
    }

    @Nullable
    public List<String> outputNames() {
        return this.outputNames;
    }

    public Map<ColumnIdent, Symbol> overwrites() {
        return this.overwrites;
    }

    public Settings withClauseOptions() {
        return this.withClauseOptions;
    }
}

