/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedCreateBlobTable;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.exceptions.RelationAlreadyExists;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.sql.tree.CreateBlobTable;
import io.crate.sql.tree.Expression;

public class CreateBlobTableAnalyzer {
    private final Schemas schemas;
    private final NodeContext nodeCtx;

    public CreateBlobTableAnalyzer(Schemas schemas, NodeContext nodeCtx) {
        this.schemas = schemas;
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedCreateBlobTable analyze(CreateBlobTable<Expression> node, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        ExpressionAnalyzer exprAnalyzerWithoutFields = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.UNSUPPORTED, null);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(txnCtx.sessionSettings());
        CreateBlobTable createBlobTable = node.map(x -> exprAnalyzerWithoutFields.convert((Expression)x, exprCtx));
        RelationName relationName = RelationName.fromBlobTable(createBlobTable.name());
        relationName.ensureValidForRelationCreation();
        if (this.schemas.tableExists(relationName)) {
            throw new RelationAlreadyExists(relationName);
        }
        return new AnalyzedCreateBlobTable(relationName, (CreateBlobTable<Symbol>)createBlobTable);
    }
}

