/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedDropTable;
import io.crate.exceptions.OperationOnInaccessibleRelationException;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.SchemaUnknownException;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.blob.BlobTableInfo;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.DropBlobTable;
import io.crate.sql.tree.DropTable;
import io.crate.sql.tree.QualifiedName;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;

class DropTableAnalyzer {
    private static final Logger LOGGER = LogManager.getLogger(DropTableAnalyzer.class);
    private final Schemas schemas;
    private final ClusterService clusterService;

    DropTableAnalyzer(ClusterService clusterService, Schemas schemas) {
        this.clusterService = clusterService;
        this.schemas = schemas;
    }

    public AnalyzedDropTable<DocTableInfo> analyze(DropTable<?> node, CoordinatorSessionSettings sessionSettings) {
        return this.analyze(node.table().getName(), node.dropIfExists(), sessionSettings);
    }

    public AnalyzedDropTable<BlobTableInfo> analyze(DropBlobTable<?> node, CoordinatorSessionSettings sessionSettings) {
        List parts = node.table().getName().getParts();
        if (parts.size() != 1 && !((String)parts.get(0)).equals("blob")) {
            throw new IllegalArgumentException("No blob tables in schema `" + (String)parts.get(0) + "`");
        }
        QualifiedName name = new QualifiedName(List.of("blob", node.table().getName().getSuffix()));
        return this.analyze(name, node.ignoreNonExistentTable(), sessionSettings);
    }

    private <T extends TableInfo> AnalyzedDropTable<T> analyze(QualifiedName name, boolean dropIfExists, CoordinatorSessionSettings sessionSettings) {
        RelationName tableName;
        try {
            TableInfo tableInfo = (TableInfo)this.schemas.findRelation(name, Operation.DROP, sessionSettings.sessionUser(), sessionSettings.searchPath());
            tableName = tableInfo.ident();
        }
        catch (RelationUnknown | SchemaUnknownException e) {
            tableName = RelationName.of(name, sessionSettings.searchPath().currentSchema());
            Metadata metadata = this.clusterService.state().metadata();
            if (!metadata.contains(tableName) && !dropIfExists) {
                throw e;
            }
        }
        catch (OperationOnInaccessibleRelationException e) {
            throw e;
        }
        catch (Throwable t) {
            if (!sessionSettings.sessionUser().isSuperUser()) {
                throw t;
            }
            tableName = RelationName.of(name, sessionSettings.searchPath().currentSchema());
            LOGGER.info("Unexpected error resolving table during DROP TABLE operation on {}. Proceeding with operation as table schema may be corrupt (error={})", (Object)tableName, (Object)t);
        }
        return new AnalyzedDropTable(dropIfExists, tableName);
    }
}

