/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.sql.tree.FrameBound;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class FrameBoundDefinition
implements Writeable {
    private final FrameBound.Type type;
    private final Symbol value;

    public FrameBoundDefinition(FrameBound.Type type, Symbol value) {
        assert (type != null) : "type must not be null";
        assert (value != null) : "value must not be null";
        this.type = type;
        this.value = value;
    }

    public FrameBoundDefinition(StreamInput in) throws IOException {
        Symbol val;
        this.type = in.readEnum(FrameBound.Type.class);
        this.value = in.getVersion().onOrAfter(Version.V_4_1_0) ? Symbol.fromStream(in) : ((val = Symbol.nullableFromStream(in)) == null ? Literal.NULL : val);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.type);
        if (out.getVersion().onOrAfter(Version.V_4_1_0)) {
            Symbol.toStream(this.value, out);
        } else {
            Symbol.nullableToStream(this.value, out);
        }
    }

    public FrameBound.Type type() {
        return this.type;
    }

    public Symbol value() {
        return this.value;
    }

    public FrameBoundDefinition map(Function<? super Symbol, ? extends Symbol> mapper) {
        Symbol newValue = mapper.apply(this.value);
        if (newValue == this.value) {
            return this;
        }
        return new FrameBoundDefinition(this.type, newValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrameBoundDefinition that = (FrameBoundDefinition)o;
        return this.type == that.type && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value);
    }

    public String toString() {
        return "FrameBound{type=" + String.valueOf(this.type) + ", value=" + String.valueOf(this.value) + "}";
    }
}

