/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedInsertStatement;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.expressions.ValueNormalizer;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.ExcludedFieldProvider;
import io.crate.analyze.relations.FieldProvider;
import io.crate.analyze.relations.FullQualifiedNameFieldProvider;
import io.crate.analyze.relations.NameFieldProvider;
import io.crate.analyze.relations.ParentRelations;
import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.analyze.relations.StatementAnalysisContext;
import io.crate.analyze.relations.select.SelectAnalysis;
import io.crate.analyze.relations.select.SelectAnalyzer;
import io.crate.common.collections.Lists;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Insert;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

class InsertAnalyzer {
    private final NodeContext nodeCtx;
    private final Schemas schemas;
    private final RelationAnalyzer relationAnalyzer;

    InsertAnalyzer(NodeContext nodeCtx, Schemas schemas, RelationAnalyzer relationAnalyzer) {
        this.nodeCtx = nodeCtx;
        this.schemas = schemas;
        this.relationAnalyzer = relationAnalyzer;
    }

    public AnalyzedInsertStatement analyze(Insert<Expression> insert, ParamTypeHints typeHints, CoordinatorTxnCtx txnCtx) {
        List<Symbol> returnValues;
        boolean ignoreDuplicateKeys;
        HashSet<String> uniqueColumns = new HashSet<String>();
        for (String columnName : insert.columns()) {
            if (uniqueColumns.add(columnName)) continue;
            throw new IllegalArgumentException("column \"" + columnName + "\" specified more than once");
        }
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.findRelation(insert.table().getName(), Operation.INSERT, txnCtx.sessionSettings().sessionUser(), txnCtx.sessionSettings().searchPath());
        List<Object> targetColumns = insert.columns().isEmpty() ? new ArrayList(tableInfo.rootColumns()) : insert.columns().stream().map(col -> tableInfo.resolveColumn((String)col, true, true)).toList();
        AnalyzedRelation subQueryRelation = this.relationAnalyzer.analyze((Node)insert.insertSource(), new StatementAnalysisContext(typeHints, Operation.READ, txnCtx, targetColumns));
        InsertAnalyzer.ensureClusteredByPresentOrNotRequired(targetColumns, tableInfo);
        InsertAnalyzer.checkSourceAndTargetColsForLengthAndTypesCompatibility(targetColumns, subQueryRelation.outputs());
        DocTableRelation tableRelation = new DocTableRelation(tableInfo);
        NameFieldProvider fieldProvider = new NameFieldProvider(tableRelation);
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, typeHints, fieldProvider, null, Operation.READ);
        InsertAnalyzer.verifyOnConflictTargets(txnCtx, expressionAnalyzer, tableInfo, (Insert.DuplicateKeyContext<Expression>)insert.duplicateKeyContext());
        Map<Reference, Symbol> onDuplicateKeyAssignments = this.processUpdateAssignments(tableRelation, targetColumns, typeHints, txnCtx, this.nodeCtx, fieldProvider, (Insert.DuplicateKeyContext<Expression>)insert.duplicateKeyContext());
        boolean bl = ignoreDuplicateKeys = insert.duplicateKeyContext().getType() == Insert.DuplicateKeyContext.Type.ON_CONFLICT_DO_NOTHING;
        if (insert.returningClause().isEmpty()) {
            returnValues = null;
        } else {
            ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(txnCtx.sessionSettings());
            Map<RelationName, AnalyzedRelation> sources = Map.of(tableRelation.relationName(), tableRelation);
            ExpressionAnalyzer sourceExprAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, typeHints, new FullQualifiedNameFieldProvider(sources, ParentRelations.NO_PARENTS, txnCtx.sessionSettings().searchPath().currentSchema()), null);
            SelectAnalysis selectAnalysis = SelectAnalyzer.analyzeSelectItems(insert.returningClause(), sources, sourceExprAnalyzer, exprCtx);
            returnValues = selectAnalysis.outputSymbols();
        }
        return new AnalyzedInsertStatement(subQueryRelation, tableInfo, targetColumns, ignoreDuplicateKeys, onDuplicateKeyAssignments, returnValues);
    }

    private static void verifyOnConflictTargets(CoordinatorTxnCtx txnCtx, ExpressionAnalyzer expressionAnalyzer, DocTableInfo docTable, Insert.DuplicateKeyContext<Expression> duplicateKeyContext) {
        List constraintColumns = duplicateKeyContext.getConstraintColumns();
        if (constraintColumns.isEmpty()) {
            return;
        }
        List<ColumnIdent> pkColumnIdents = docTable.primaryKey();
        if (constraintColumns.size() != pkColumnIdents.size()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Number of conflict targets (%s) did not match the number of primary key columns (%s)", constraintColumns, pkColumnIdents));
        }
        ExpressionAnalysisContext ctx = new ExpressionAnalysisContext(txnCtx.sessionSettings());
        List conflictTargets = Lists.map((Collection)constraintColumns, x -> {
            try {
                return expressionAnalyzer.convert((Expression)x, ctx);
            }
            catch (ColumnUnknownException e) {
                if (x instanceof QualifiedNameReference) {
                    QualifiedNameReference qnameRef = (QualifiedNameReference)x;
                    QualifiedName name = qnameRef.getName();
                    Expression subscriptExpression = ColumnIdent.fromPath(name.toString()).toExpression();
                    return expressionAnalyzer.convert(subscriptExpression, ctx);
                }
                throw e;
            }
        });
        for (Symbol conflictTarget : conflictTargets) {
            if (pkColumnIdents.contains(conflictTarget.toColumn())) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Conflict target (%s) did not match the primary key columns (%s)", conflictTarget, pkColumnIdents));
        }
    }

    private static void ensureClusteredByPresentOrNotRequired(List<Reference> targetColumnRefs, DocTableInfo tableInfo) {
        GeneratedReference generatedClusteredBy;
        List topLevelDependencies;
        ColumnIdent clusteredBy = tableInfo.clusteredBy();
        if (clusteredBy == null || clusteredBy.equals(SysColumns.ID.COLUMN)) {
            return;
        }
        Reference clusteredByRef = tableInfo.getReference(clusteredBy);
        if (clusteredByRef.defaultExpression() != null) {
            return;
        }
        ColumnIdent clusteredByRoot = clusteredBy.getRoot();
        List targetColumns = Lists.mapLazy(targetColumnRefs, Reference::column);
        if (targetColumns.contains(clusteredByRoot)) {
            return;
        }
        if (clusteredByRef instanceof GeneratedReference && targetColumns.containsAll(topLevelDependencies = Lists.mapLazy((generatedClusteredBy = (GeneratedReference)clusteredByRef).referencedReferences(), x -> x.column().getRoot()))) {
            return;
        }
        throw new IllegalArgumentException("Column `" + String.valueOf(clusteredBy) + "` is required but is missing from the insert statement");
    }

    private static void checkSourceAndTargetColsForLengthAndTypesCompatibility(List<Reference> targetColumns, List<Symbol> sources) {
        if (targetColumns.size() != sources.size()) {
            Collector<CharSequence, ?, String> commaJoiner = Collectors.joining(", ");
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Number of target columns (%s) of insert statement doesn't match number of source columns (%s)", targetColumns.stream().map(r -> r.column().sqlFqn()).collect(commaJoiner), sources.stream().map((Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)()).collect(commaJoiner)));
        }
        for (int i = 0; i < targetColumns.size(); ++i) {
            Reference targetCol = targetColumns.get(i);
            Symbol source = sources.get(i);
            DataType<?> targetType = targetCol.valueType();
            if (targetType.id() == DataTypes.UNDEFINED.id() || source.valueType().isConvertableTo(targetType, false)) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The type '%s' of the insert source '%s' is not convertible to the type '%s' of target column '%s'", source.valueType(), source, targetType, targetCol.column().fqn()));
        }
    }

    private static Map<Reference, Symbol> getUpdateAssignments(DocTableRelation targetTable, List<Reference> targetCols, ExpressionAnalyzer exprAnalyzer, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, ParamTypeHints paramTypeHints, Insert.DuplicateKeyContext<Expression> duplicateKeyContext) {
        if (duplicateKeyContext.getAssignments().isEmpty()) {
            return Collections.emptyMap();
        }
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(txnCtx.sessionSettings());
        ValuesResolver valuesResolver = new ValuesResolver(targetCols);
        FieldProvider<Symbol> fieldProvider = duplicateKeyContext.getType() == Insert.DuplicateKeyContext.Type.ON_CONFLICT_DO_UPDATE_SET ? new ExcludedFieldProvider(new NameFieldProvider(targetTable), valuesResolver) : new NameFieldProvider(targetTable);
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(txnCtx, nodeCtx, paramTypeHints, fieldProvider, null);
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(nodeCtx, RowGranularity.CLUSTER, null, targetTable, f -> f.signature().isDeterministic());
        HashMap<Reference, Symbol> updateAssignments = HashMap.newHashMap(duplicateKeyContext.getAssignments().size());
        for (Assignment assignment : duplicateKeyContext.getAssignments()) {
            Reference targetCol = (Reference)exprAnalyzer.convert((Expression)assignment.columnName(), exprCtx);
            Symbol valueSymbol = ValueNormalizer.normalizeInputForReference(normalizer.normalize(expressionAnalyzer.convert((Expression)assignment.expression(), exprCtx), txnCtx), targetCol, targetTable.tableInfo(), s -> normalizer.normalize((Symbol)s, txnCtx));
            updateAssignments.put(targetCol, valueSymbol);
        }
        return updateAssignments;
    }

    private Map<Reference, Symbol> processUpdateAssignments(DocTableRelation tableRelation, List<Reference> targetColumns, ParamTypeHints paramTypeHints, CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, FieldProvider<?> fieldProvider, Insert.DuplicateKeyContext<Expression> duplicateKeyContext) {
        if (duplicateKeyContext.getAssignments().isEmpty()) {
            return Collections.emptyMap();
        }
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(coordinatorTxnCtx, nodeCtx, paramTypeHints, fieldProvider, null, Operation.UPDATE);
        return InsertAnalyzer.getUpdateAssignments(tableRelation, targetColumns, expressionAnalyzer, coordinatorTxnCtx, nodeCtx, paramTypeHints, duplicateKeyContext);
    }

    private static class ValuesResolver
    implements io.crate.analyze.ValuesResolver {
        private final List<Reference> targetColumns;

        ValuesResolver(List<Reference> targetColumns) {
            this.targetColumns = targetColumns;
        }

        @Override
        public Symbol allocateAndResolve(Symbol argumentColumn) {
            int i;
            int n = i = argumentColumn instanceof Reference ? this.targetColumns.indexOf(argumentColumn) : -1;
            if (i < 0) {
                throw new IllegalArgumentException(Symbols.format("Column '%s' that is used in the VALUES() expression is not part of the target column list", argumentColumn));
            }
            return new InputColumn(i, argumentColumn.valueType());
        }
    }
}

