/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.sql.tree.ClusteredBy;
import io.crate.types.DataTypes;
import java.util.Locale;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class NumberOfShards {
    private static final Integer MIN_NUM_SHARDS = 4;
    private final ClusterService clusterService;

    @Inject
    public NumberOfShards(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public int fromNumberOfShards(Object numberOfShards) {
        if (!(numberOfShards instanceof Number)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "invalid number '%s'", numberOfShards));
        }
        Integer numShards = DataTypes.INTEGER.sanitizeValue(numberOfShards);
        if (numShards < 1) {
            throw new IllegalArgumentException("num_shards in CLUSTERED clause must be greater than 0");
        }
        return numShards;
    }

    public int fromClusteredByClause(ClusteredBy<Object> clusteredBy) {
        return clusteredBy.numberOfShards().map(this::fromNumberOfShards).orElseGet(this::defaultNumberOfShards);
    }

    public int defaultNumberOfShards() {
        int numDataNodes = this.clusterService.state().nodes().getDataNodes().size();
        assert (numDataNodes >= 0) : "number of data nodes cannot be less than 0";
        return Math.max(MIN_NUM_SHARDS, numDataNodes * 2);
    }
}

