/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.common.Booleans;
import io.crate.common.collections.Lists;
import io.crate.expression.symbol.Symbol;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.Nullable;

public class OrderBy
implements Writeable {
    private static final boolean REVERSE_FLAG_DEFAULT_ASC = false;
    private static final Boolean NULLS_FIRST_DEFAULT_FOR_ASC = false;
    private final List<Symbol> orderBySymbols;
    private final boolean[] reverseFlags;
    private final boolean[] nullsFirst;

    public OrderBy(List<Symbol> orderBySymbols) {
        this.orderBySymbols = orderBySymbols;
        this.reverseFlags = new boolean[orderBySymbols.size()];
        this.nullsFirst = new boolean[orderBySymbols.size()];
        Arrays.fill(this.reverseFlags, false);
        Arrays.fill(this.nullsFirst, NULLS_FIRST_DEFAULT_FOR_ASC);
    }

    public OrderBy(List<Symbol> orderBySymbols, boolean[] reverseFlags, boolean[] nullsFirst) {
        assert (!orderBySymbols.isEmpty()) : "orderBySymbols must not be empty";
        assert (orderBySymbols.size() == reverseFlags.length && reverseFlags.length == nullsFirst.length) : "size of symbols / reverseFlags / nullsFirst must match";
        this.orderBySymbols = orderBySymbols;
        this.reverseFlags = reverseFlags;
        this.nullsFirst = nullsFirst;
    }

    public OrderBy prependUnique(Collection<? extends Symbol> symbols) {
        Symbol nextOrderBy;
        if (symbols.isEmpty()) {
            return this;
        }
        int newEstimatedSize = this.orderBySymbols.size() + symbols.size();
        ArrayList<Symbol> newOrderBySymbols = new ArrayList<Symbol>(newEstimatedSize);
        ArrayList<Boolean> newReverseFlags = new ArrayList<Boolean>(newEstimatedSize);
        ArrayList<Boolean> newNullsFirst = new ArrayList<Boolean>(newEstimatedSize);
        ListIterator<Symbol> orderBySymbols = this.orderBySymbols.listIterator();
        Iterator<? extends Symbol> xsToPrepend = symbols.iterator();
        Symbol symbol = nextOrderBy = orderBySymbols.hasNext() ? orderBySymbols.next() : null;
        while (xsToPrepend.hasNext()) {
            Symbol toPrepend = xsToPrepend.next();
            if (toPrepend.equals(nextOrderBy)) {
                newOrderBySymbols.add(nextOrderBy);
                newReverseFlags.add(this.reverseFlags[orderBySymbols.previousIndex()]);
                newNullsFirst.add(this.nullsFirst[orderBySymbols.previousIndex()]);
                nextOrderBy = orderBySymbols.hasNext() ? orderBySymbols.next() : null;
                continue;
            }
            newOrderBySymbols.add(toPrepend);
            newReverseFlags.add(false);
            newNullsFirst.add(NULLS_FIRST_DEFAULT_FOR_ASC);
        }
        if (nextOrderBy != null) {
            newOrderBySymbols.add(nextOrderBy);
            newReverseFlags.add(this.reverseFlags[orderBySymbols.previousIndex()]);
            newNullsFirst.add(this.nullsFirst[orderBySymbols.previousIndex()]);
        }
        while (orderBySymbols.hasNext()) {
            newOrderBySymbols.add(orderBySymbols.next());
            newReverseFlags.add(this.reverseFlags[orderBySymbols.previousIndex()]);
            newNullsFirst.add(this.nullsFirst[orderBySymbols.previousIndex()]);
        }
        return new OrderBy(newOrderBySymbols, Booleans.toArray(newReverseFlags), Booleans.toArray(newNullsFirst));
    }

    public List<Symbol> orderBySymbols() {
        return this.orderBySymbols;
    }

    public boolean[] reverseFlags() {
        return this.reverseFlags;
    }

    public boolean[] nullsFirst() {
        return this.nullsFirst;
    }

    public OrderBy(StreamInput in) throws IOException {
        int i;
        int numOrderBy = in.readVInt();
        this.reverseFlags = new boolean[numOrderBy];
        for (i = 0; i < numOrderBy; ++i) {
            this.reverseFlags[i] = in.readBoolean();
        }
        this.orderBySymbols = new ArrayList<Symbol>(numOrderBy);
        for (i = 0; i < numOrderBy; ++i) {
            this.orderBySymbols.add(Symbol.fromStream(in));
        }
        this.nullsFirst = new boolean[numOrderBy];
        for (i = 0; i < numOrderBy; ++i) {
            this.nullsFirst[i] = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.reverseFlags.length);
        for (boolean reverseFlag : this.reverseFlags) {
            out.writeBoolean(reverseFlag);
        }
        for (Symbol symbol : this.orderBySymbols) {
            Symbol.toStream(symbol, out);
        }
        for (boolean nullFirst : this.nullsFirst) {
            out.writeBoolean(nullFirst);
        }
    }

    public OrderBy map(Function<? super Symbol, ? extends Symbol> replaceFunction) {
        return new OrderBy(Lists.map(this.orderBySymbols, replaceFunction), this.reverseFlags, this.nullsFirst);
    }

    @Nullable
    public OrderBy exclude(Predicate<? super Symbol> predicate) {
        ArrayList<Symbol> newOrderBySymbols = new ArrayList<Symbol>(this.orderBySymbols.size());
        ArrayList<Boolean> newReverseFlags = new ArrayList<Boolean>(this.reverseFlags.length);
        ArrayList<Boolean> newNullsFirst = new ArrayList<Boolean>(this.nullsFirst.length);
        for (int i = 0; i < this.orderBySymbols.size(); ++i) {
            Symbol sortSymbol = this.orderBySymbols.get(i);
            if (predicate.test(sortSymbol)) continue;
            newOrderBySymbols.add(sortSymbol);
            newReverseFlags.add(this.reverseFlags[i]);
            newNullsFirst.add(this.nullsFirst[i]);
        }
        if (newOrderBySymbols.isEmpty()) {
            return null;
        }
        return new OrderBy(newOrderBySymbols, Booleans.toArray(newReverseFlags), Booleans.toArray(newNullsFirst));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderBy orderBy = (OrderBy)o;
        return this.orderBySymbols.equals(orderBy.orderBySymbols) && Arrays.equals(this.reverseFlags, orderBy.reverseFlags) && Arrays.equals(this.nullsFirst, orderBy.nullsFirst);
    }

    public int hashCode() {
        return Objects.hash(this.orderBySymbols) + Arrays.deepHashCode(new Object[]{this.reverseFlags, this.nullsFirst});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OrderBy{");
        OrderBy.explainRepresentation(sb, this.orderBySymbols, this.reverseFlags, this.nullsFirst, (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)());
        sb.append("}");
        return sb.toString();
    }

    public String explainRepresentation() {
        StringBuilder sb = new StringBuilder();
        return OrderBy.explainRepresentation(sb, this.orderBySymbols, this.reverseFlags, this.nullsFirst, (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)()).toString();
    }

    public static StringBuilder explainRepresentation(StringBuilder sb, List<? extends Symbol> symbols, boolean[] reverseFlags, boolean[] nullsFirst, Function<? super Symbol, String> toString) {
        for (int i = 0; i < symbols.size(); ++i) {
            Symbol symbol = symbols.get(i);
            sb.append(toString.apply(symbol));
            sb.append(" ");
            if (reverseFlags[i]) {
                sb.append("DESC");
            } else {
                sb.append("ASC");
            }
            boolean nullFirst = nullsFirst[i];
            if (reverseFlags[i] != nullFirst) {
                sb.append(" ");
                sb.append(nullFirst ? "NULLS FIRST" : "NULLS LAST");
            }
            if (i + 1 >= symbols.size()) continue;
            sb.append(" ");
        }
        return sb;
    }

    public void accept(Consumer<? super Symbol> consumer) {
        for (Symbol sortItem : this.orderBySymbols) {
            consumer.accept(sortItem);
        }
    }
}

