/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedSetStatement;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.SetStatement;

class SetStatementAnalyzer {
    private final NodeContext nodeCtx;

    SetStatementAnalyzer(NodeContext nodeCtx) {
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedStatement analyze(SetStatement<Expression> node, ParamTypeHints typeHints, CoordinatorTxnCtx txnCtx) {
        boolean isPersistent = node.settingType().equals((Object)SetStatement.SettingType.PERSISTENT);
        ExpressionAnalyzer exprAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, typeHints, FieldProvider.TO_LITERAL_UNSAFE, null);
        SetStatement statement = node.map(x -> exprAnalyzer.convert((Expression)x, new ExpressionAnalysisContext(txnCtx.sessionSettings())));
        return new AnalyzedSetStatement(node.scope(), statement.assignments(), isPersistent);
    }
}

