/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.SubscriptContext;
import io.crate.sql.tree.ArrayLiteral;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Cast;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.FunctionCall;
import io.crate.sql.tree.IntegerLiteral;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.ObjectLiteral;
import io.crate.sql.tree.ParameterExpression;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.StringLiteral;
import io.crate.sql.tree.SubqueryExpression;
import io.crate.sql.tree.SubscriptExpression;
import io.crate.sql.tree.TryCast;
import java.util.Locale;

public final class SubscriptVisitor {
    private SubscriptVisitor() {
    }

    public static SubscriptContext visit(Expression node) {
        SubscriptContext subscriptContext = new SubscriptContext();
        node.accept((AstVisitor)SubscriptNameVisitor.INSTANCE, (Object)subscriptContext);
        return subscriptContext;
    }

    private static class SubscriptNameVisitor
    extends AstVisitor<Void, SubscriptContext> {
        private static final SubscriptNameVisitor INSTANCE = new SubscriptNameVisitor();

        private SubscriptNameVisitor() {
        }

        protected Void visitSubscriptExpression(SubscriptExpression node, SubscriptContext context) {
            node.index().accept((AstVisitor)SubscriptIndexVisitor.INSTANCE, (Object)context);
            node.base().accept((AstVisitor)this, (Object)context);
            return null;
        }

        protected Void visitQualifiedNameReference(QualifiedNameReference node, SubscriptContext context) {
            context.qualifiedName(node.getName());
            return null;
        }

        public Void visitArrayLiteral(ArrayLiteral node, SubscriptContext context) {
            context.setHasExpression();
            return null;
        }

        public Void visitObjectLiteral(ObjectLiteral node, SubscriptContext context) {
            context.setHasExpression();
            return null;
        }

        protected Void visitCast(Cast node, SubscriptContext context) {
            context.setHasExpression();
            return null;
        }

        protected Void visitTryCast(TryCast node, SubscriptContext context) {
            context.setHasExpression();
            return null;
        }

        protected Void visitFunctionCall(FunctionCall node, SubscriptContext context) {
            context.setHasExpression();
            return null;
        }

        protected Void visitSubqueryExpression(SubqueryExpression node, SubscriptContext context) {
            context.setHasExpression();
            return null;
        }

        protected Void visitExpression(Expression node, SubscriptContext context) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "An expression of type %s cannot have an index accessor ([])", node.getClass().getSimpleName()));
        }
    }

    private static class SubscriptIndexVisitor
    extends AstVisitor<Void, SubscriptContext> {
        private static final SubscriptIndexVisitor INSTANCE = new SubscriptIndexVisitor();

        private SubscriptIndexVisitor() {
        }

        public Void visitParameterExpression(ParameterExpression node, SubscriptContext context) {
            throw new UnsupportedOperationException("Parameter substitution is not supported in subscript index");
        }

        protected Void visitStringLiteral(StringLiteral node, SubscriptContext context) {
            context.addKey(node.getValue());
            return null;
        }

        protected Void visitLongLiteral(LongLiteral node, SubscriptContext context) {
            context.addIndex((Expression)node);
            return null;
        }

        protected Void visitIntegerLiteral(IntegerLiteral node, SubscriptContext context) {
            context.addIndex((Expression)node);
            return null;
        }

        protected Void visitExpression(Expression node, SubscriptContext context) {
            context.addIndex(node);
            return null;
        }
    }
}

