/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.FrameBoundDefinition;
import io.crate.analyze.OrderBy;
import io.crate.analyze.WindowFrameDefinition;
import io.crate.common.collections.Lists;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.sql.tree.FrameBound;
import io.crate.sql.tree.WindowFrame;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.Nullable;

public class WindowDefinition
implements Writeable {
    public static final WindowFrameDefinition RANGE_UNBOUNDED_PRECEDING_CURRENT_ROW = new WindowFrameDefinition(WindowFrame.Mode.RANGE, new FrameBoundDefinition(FrameBound.Type.UNBOUNDED_PRECEDING, Literal.NULL), new FrameBoundDefinition(FrameBound.Type.CURRENT_ROW, Literal.NULL));
    private final List<Symbol> partitions;
    @Nullable
    private final OrderBy orderBy;
    private final WindowFrameDefinition windowFrameDefinition;

    public WindowDefinition(StreamInput in) throws IOException {
        this.partitions = Symbols.fromStream(in);
        this.orderBy = in.readOptionalWriteable(OrderBy::new);
        this.windowFrameDefinition = new WindowFrameDefinition(in);
    }

    public WindowDefinition(List<Symbol> partitions, @Nullable OrderBy orderBy, @Nullable WindowFrameDefinition windowFrameDefinition) {
        this.partitions = partitions;
        this.orderBy = orderBy;
        this.windowFrameDefinition = windowFrameDefinition == null ? RANGE_UNBOUNDED_PRECEDING_CURRENT_ROW : windowFrameDefinition;
    }

    public List<Symbol> partitions() {
        return this.partitions;
    }

    public WindowDefinition map(Function<? super Symbol, ? extends Symbol> mapper) {
        return new WindowDefinition(Lists.map(this.partitions, mapper), this.orderBy != null ? this.orderBy.map(mapper) : null, this.windowFrameDefinition.map(mapper));
    }

    @Nullable
    public OrderBy orderBy() {
        return this.orderBy;
    }

    public WindowFrameDefinition windowFrameDefinition() {
        return this.windowFrameDefinition;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.partitions.size());
        for (Symbol partition : this.partitions) {
            Symbol.toStream(partition, out);
        }
        out.writeOptionalWriteable(this.orderBy);
        this.windowFrameDefinition.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowDefinition that = (WindowDefinition)o;
        return Objects.equals(this.partitions, that.partitions) && Objects.equals(this.orderBy, that.orderBy) && Objects.equals(this.windowFrameDefinition, that.windowFrameDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.partitions, this.orderBy, this.windowFrameDefinition);
    }

    public String toString() {
        return "WindowDefinition{partitions=" + String.valueOf(this.partitions) + ", orderBy=" + String.valueOf(this.orderBy) + ", windowFrame=" + String.valueOf(this.windowFrameDefinition) + "}";
    }
}

