/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.expressions;

import io.crate.analyze.relations.FieldProvider;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class TableReferenceResolver
implements FieldProvider<Reference> {
    private final Map<ColumnIdent, Reference> references;
    private final RelationName relationName;

    public TableReferenceResolver(Map<ColumnIdent, Reference> references, RelationName relationName) {
        this.references = references;
        this.relationName = relationName;
    }

    @Override
    public Reference resolveField(QualifiedName qualifiedName, @Nullable List<String> path, Operation operation, boolean errorOnUnknownObjectKey) {
        ColumnIdent columnIdent = ColumnIdent.fromNameSafe(qualifiedName, path);
        Reference reference = this.references.get(columnIdent);
        if (reference == null) {
            throw new ColumnUnknownException(columnIdent, this.relationName);
        }
        return reference;
    }
}

