/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.FieldResolver;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.TableInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTableRelation<T extends TableInfo>
implements AnalyzedRelation,
FieldResolver {
    protected final T tableInfo;
    private final List<Symbol> outputs;
    private final List<Symbol> hiddenOutputs;

    protected AbstractTableRelation(T tableInfo, List<Symbol> outputs, List<Symbol> hiddenOutputs) {
        this.tableInfo = tableInfo;
        this.outputs = outputs;
        this.hiddenOutputs = hiddenOutputs;
    }

    public T tableInfo() {
        return this.tableInfo;
    }

    @Override
    @NotNull
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public List<Symbol> hiddenOutputs() {
        return this.hiddenOutputs;
    }

    @Nullable
    public Reference getField(ColumnIdent path) {
        return this.tableInfo.getReadReference(path);
    }

    @Override
    public RelationName relationName() {
        return this.tableInfo.ident();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + String.valueOf(this.tableInfo.ident()) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTableRelation that = (AbstractTableRelation)o;
        return this.tableInfo.equals(that.tableInfo);
    }

    public int hashCode() {
        return this.tableInfo.hashCode();
    }

    @Override
    @Nullable
    public Reference resolveField(ScopedSymbol field) {
        if (field.relation().equals(this.tableInfo.ident())) {
            return this.getField(field.column());
        }
        return null;
    }
}

