/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.where;

import io.crate.analyze.Id;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataTypes;
import io.crate.types.LongType;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class DocKeys
implements Iterable<DocKey> {
    private final int width;
    private final Function<List<String>, String> idFunction;
    private final boolean withSequenceVersioning;
    private final int clusteredByIdx;
    private final boolean withVersions;
    private final List<List<Symbol>> docKeys;
    private final List<Integer> partitionIdx;

    public DocKeys(List<List<Symbol>> docKeys, boolean withVersions, boolean withSequenceVersioning, int clusteredByIdx, @Nullable List<Integer> partitionIdx) {
        this.partitionIdx = partitionIdx;
        assert (docKeys != null && !docKeys.isEmpty()) : "docKeys must not be null nor empty";
        this.width = withVersions ? docKeys.get(0).size() - 1 : (withSequenceVersioning ? docKeys.get(0).size() - 2 : docKeys.get(0).size());
        this.withVersions = withVersions;
        this.withSequenceVersioning = withSequenceVersioning;
        this.docKeys = docKeys;
        this.clusteredByIdx = clusteredByIdx;
        this.idFunction = Id.compile(this.width, clusteredByIdx);
    }

    public DocKey getOnlyKey() {
        if (this.size() != 1) {
            throw new IllegalArgumentException("must contain only one key");
        }
        return new DocKey(0);
    }

    public int size() {
        return this.docKeys.size();
    }

    @Override
    public Iterator<DocKey> iterator() {
        return new Iterator<DocKey>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < DocKeys.this.docKeys.size();
            }

            @Override
            public DocKey next() {
                return new DocKey(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported for " + DocKeys.class.getSimpleName() + "$iterator");
            }
        };
    }

    public String toString() {
        return "DocKeys{" + this.docKeys.stream().map(xs -> Lists.joinOn((String)", ", (List)xs, (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)())).sorted().collect(Collectors.joining("; ")) + "}";
    }

    public class DocKey {
        private final List<Symbol> key;

        private DocKey(int pos) {
            this.key = DocKeys.this.docKeys.get(pos);
        }

        public String getId(TransactionContext txnCtx, NodeContext nodeCtx, Row params, SubQueryResults subQueryResults) {
            return DocKeys.this.idFunction.apply(Lists.mapLazy(this.key.subList(0, DocKeys.this.width), s -> DataTypes.STRING.implicitCast(SymbolEvaluator.evaluate(txnCtx, nodeCtx, s, params, subQueryResults))));
        }

        public Optional<Long> version(TransactionContext txnCtx, NodeContext nodeCtx, Row params, SubQueryResults subQueryResults) {
            if (DocKeys.this.withVersions && this.key.get(DocKeys.this.width) != null) {
                Object val = SymbolEvaluator.evaluate(txnCtx, nodeCtx, this.key.get(DocKeys.this.width), params, subQueryResults);
                return Optional.of(DataTypes.LONG.sanitizeValue(val));
            }
            return Optional.empty();
        }

        public Optional<Long> sequenceNo(TransactionContext txnCtx, NodeContext nodeCtx, Row params, SubQueryResults subQueryResults) {
            if (DocKeys.this.withSequenceVersioning && this.key.get(DocKeys.this.width) != null) {
                Object val = SymbolEvaluator.evaluate(txnCtx, nodeCtx, this.key.get(DocKeys.this.width), params, subQueryResults);
                return Optional.of(LongType.INSTANCE.sanitizeValue(val));
            }
            return Optional.empty();
        }

        public Optional<Long> primaryTerm(TransactionContext txnCtx, NodeContext nodeCtx, Row params, SubQueryResults subQueryResults) {
            if (DocKeys.this.withSequenceVersioning && this.key.get(DocKeys.this.width + 1) != null) {
                Object val = SymbolEvaluator.evaluate(txnCtx, nodeCtx, this.key.get(DocKeys.this.width + 1), params, subQueryResults);
                return Optional.of(LongType.INSTANCE.sanitizeValue(val));
            }
            return Optional.empty();
        }

        public List<Symbol> values() {
            return this.key;
        }

        public List<String> getPartitionValues(TransactionContext txnCtx, NodeContext nodeCtx, Row params, SubQueryResults subQueryResults) {
            if (DocKeys.this.partitionIdx == null || DocKeys.this.partitionIdx.isEmpty()) {
                return Collections.emptyList();
            }
            return Lists.map(DocKeys.this.partitionIdx, pIdx -> DataTypes.STRING.implicitCast(SymbolEvaluator.evaluate(txnCtx, nodeCtx, this.key.get((int)pIdx), params, subQueryResults)));
        }

        public String getRouting(TransactionContext txnCtx, NodeContext nodeCtx, Row params, SubQueryResults subQueryResults) {
            if (DocKeys.this.clusteredByIdx >= 0) {
                return SymbolEvaluator.evaluate(txnCtx, nodeCtx, this.key.get(DocKeys.this.clusteredByIdx), params, subQueryResults).toString();
            }
            return this.getId(txnCtx, nodeCtx, params, subQueryResults);
        }
    }
}

