/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.crate.role.JwtProperties;
import io.crate.role.Role;
import java.io.Closeable;
import java.util.function.Predicate;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Credentials
implements Closeable {
    private static final JWT JWT = new JWT();
    private String username;
    private SecureString password;
    private final DecodedJWT decodedToken;

    private Credentials(@Nullable String username, @Nullable char[] password, @Nullable String jwtToken) {
        this.username = username;
        SecureString secureString = this.password = password != null ? new SecureString(password) : null;
        if (jwtToken != null) {
            this.decodedToken = JWT.decodeJwt(jwtToken);
            Credentials.validateToken(this.decodedToken);
        } else {
            this.decodedToken = null;
        }
    }

    public Credentials(String username, @Nullable char[] password) {
        this(username, password, null);
    }

    public Credentials(@NotNull String jwtToken) {
        this(null, null, jwtToken);
    }

    public void setPassword(@NotNull char[] password) {
        this.password = new SecureString(password);
    }

    public void setUsername(@NotNull String username) {
        this.username = username;
    }

    @Nullable
    public String username() {
        return this.username;
    }

    @Nullable
    public SecureString password() {
        return this.password;
    }

    @Nullable
    public DecodedJWT decodedToken() {
        return this.decodedToken;
    }

    @Override
    public void close() {
        if (this.password != null) {
            this.password.close();
        }
    }

    private static void validateToken(@NotNull DecodedJWT decodedToken) {
        if (Strings.isNullOrEmpty(decodedToken.getKeyId())) {
            throw new IllegalArgumentException("The JWT token must contain a public key id (kid)");
        }
        if (Strings.isNullOrEmpty(decodedToken.getIssuer())) {
            throw new IllegalArgumentException("The JWT token must contain an issuer (iss)");
        }
        if (Strings.isNullOrEmpty(decodedToken.getClaim("username").asString())) {
            throw new IllegalArgumentException("The JWT token must contain a 'username' claim");
        }
    }

    @Nullable
    public Predicate<Role> matchByToken(boolean checkJwtProperties) {
        if (this.decodedToken != null) {
            if (checkJwtProperties) {
                return role -> {
                    JwtProperties jwtProperties = role.jwtProperties();
                    if (role.isUser() && jwtProperties != null) {
                        assert (jwtProperties.iss() != null && jwtProperties.username() != null) : "If user has jwt properties, 'iss' and 'username' must be not null";
                        return jwtProperties.match(this.decodedToken.getIssuer(), this.decodedToken.getClaim("username").asString());
                    }
                    return false;
                };
            }
            return role -> {
                if (role.isUser()) {
                    return role.name().equals(this.decodedToken.getClaim("username").asString());
                }
                return false;
            };
        }
        return null;
    }
}

