/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth;

import io.crate.auth.AuthenticationMethod;
import io.crate.auth.Credentials;
import io.crate.protocols.postgres.ConnectionProperties;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.SecureHash;
import org.elasticsearch.common.settings.SecureString;
import org.jetbrains.annotations.Nullable;

public class PasswordAuthenticationMethod
implements AuthenticationMethod {
    public static final String NAME = "password";
    private final Roles roles;

    PasswordAuthenticationMethod(Roles roles) {
        this.roles = roles;
    }

    @Override
    @Nullable
    public Role authenticate(Credentials credentials, ConnectionProperties connProperties) {
        SecureHash secureHash;
        String username = credentials.username();
        SecureString password = credentials.password();
        assert (username != null) : "User name must be not null on password authentication method";
        Role user = this.roles.findUser(username);
        if (user != null && password != null && !password.isEmpty() && (secureHash = user.password()) != null && secureHash.verifyHash(password)) {
            return user;
        }
        throw new RuntimeException("password authentication failed for user \"" + username + "\"");
    }

    @Override
    public String name() {
        return NAME;
    }
}

