/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob.recovery;

import io.crate.blob.BlobContainer;
import io.crate.blob.BlobTransferTarget;
import io.crate.blob.v2.BlobIndex;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.blob.v2.BlobShard;
import io.crate.common.Hex;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.PlainFuture;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.indices.recovery.BlobFinalizeRecoveryRequest;
import org.elasticsearch.indices.recovery.BlobRecoveryChunkRequest;
import org.elasticsearch.indices.recovery.BlobRecoveryDeleteRequest;
import org.elasticsearch.indices.recovery.BlobRecoveryStartTransferRequest;
import org.elasticsearch.indices.recovery.BlobStartPrefixResponse;
import org.elasticsearch.indices.recovery.BlobStartPrefixSyncRequest;
import org.elasticsearch.indices.recovery.BlobStartRecoveryRequest;
import org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.elasticsearch.indices.recovery.RecoveryTargetHandler;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class BlobRecoveryHandler
extends RecoverySourceHandler {
    private static final Logger LOGGER = LogManager.getLogger(BlobRecoveryHandler.class);
    private final StartRecoveryRequest request;
    private final TransportService transportService;
    private final BlobShard blobShard;
    private final IndexShard shard;
    private final BlobTransferTarget blobTransferTarget;
    private final int GET_HEAD_TIMEOUT;

    public BlobRecoveryHandler(IndexShard shard, RecoveryTargetHandler recoveryTarget, StartRecoveryRequest request, int fileChunkSizeInBytes, int maxConcurrentFileChunks, int maxConcurrentOperations, TransportService transportService, BlobTransferTarget blobTransferTarget, BlobIndicesService blobIndicesService) {
        super(shard, recoveryTarget, shard.getThreadPool(), request, fileChunkSizeInBytes, maxConcurrentFileChunks, maxConcurrentOperations);
        assert (BlobIndex.isBlobIndex(shard.shardId().getIndexName())) : "Shard must belong to a blob index";
        this.blobShard = blobIndicesService.blobShardSafe(request.shardId());
        this.request = request;
        this.transportService = transportService;
        this.blobTransferTarget = blobTransferTarget;
        this.shard = shard;
        String property = System.getProperty("tests.short_timeouts");
        this.GET_HEAD_TIMEOUT = property == null ? 30 : 2;
    }

    private Set<BytesArray> getExistingDigestsFromTarget(byte prefix) {
        PlainFuture listener = new PlainFuture();
        this.transportService.sendRequest(this.request.targetNode(), "internal:crate:blob/shard/recovery/start_prefix", (TransportRequest)new BlobStartPrefixSyncRequest(this.request.recoveryId(), this.request.shardId(), prefix), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<BlobStartPrefixResponse>("internal:crate:blob/shard/recovery/start_prefix", listener, BlobStartPrefixResponse::new));
        BlobStartPrefixResponse response = (BlobStartPrefixResponse)FutureUtils.get(listener);
        HashSet<BytesArray> result = new HashSet<BytesArray>();
        for (byte[] digests : response.existingDigests) {
            result.add(new BytesArray(digests));
        }
        return result;
    }

    @Override
    protected void blobRecoveryHook() throws Exception {
        LOGGER.debug("[{}][{}] recovery [phase1] to {}: start", (Object)this.request.shardId().getIndexName(), (Object)this.request.shardId().id(), (Object)this.request.targetNode().getName());
        StopWatch stopWatch = new StopWatch().start();
        this.blobTransferTarget.startRecovery();
        this.blobTransferTarget.createActiveTransfersSnapshot();
        this.sendStartRecoveryRequest();
        AtomicReference<Exception> lastException = new AtomicReference<Exception>();
        try {
            this.syncVarFiles(lastException);
        }
        catch (InterruptedException ex) {
            throw new ElasticsearchException("blob recovery phase1 failed", (Throwable)ex, new Object[0]);
        }
        Exception exception = lastException.get();
        if (exception != null) {
            throw exception;
        }
        this.blobTransferTarget.waitForGetHeadRequests(this.GET_HEAD_TIMEOUT, TimeUnit.SECONDS);
        this.blobTransferTarget.createActivePutHeadChunkTransfersSnapshot();
        this.blobTransferTarget.waitUntilPutHeadChunksAreFinished();
        this.sendFinalizeRecoveryRequest();
        this.blobTransferTarget.stopRecovery();
        stopWatch.stop();
        LOGGER.debug("[{}][{}] recovery [phase1] to {}: took [{}]", (Object)this.request.shardId().getIndexName(), (Object)this.request.shardId().id(), (Object)this.request.targetNode().getName(), (Object)stopWatch.totalTime());
    }

    private void syncVarFiles(AtomicReference<Exception> lastException) throws InterruptedException, IOException {
        for (byte prefix : BlobContainer.PREFIXES) {
            Set<BytesArray> remoteDigests = this.getExistingDigestsFromTarget(prefix);
            HashSet<BytesArray> localDigests = new HashSet<BytesArray>();
            for (byte[] digest : this.blobShard.currentDigests(prefix)) {
                localDigests.add(new BytesArray(digest));
            }
            HashSet localButNotRemoteDigests = new HashSet(localDigests);
            localButNotRemoteDigests.removeAll(remoteDigests);
            CountDownLatch latch = new CountDownLatch(localButNotRemoteDigests.size());
            for (BytesArray digestBytes : localButNotRemoteDigests) {
                String digest = Hex.encodeHexString((byte[])BytesReference.toBytes(digestBytes));
                LOGGER.trace("[{}][{}] start to transfer file var/{} to {}", (Object)this.request.shardId().getIndexName(), (Object)this.request.shardId().id(), (Object)digest, (Object)this.request.targetNode().getName());
                this.cancellableThreads.execute(new TransferFileRunnable(this.blobShard.blobContainer().getFile(digest), lastException, latch));
            }
            latch.await();
            remoteDigests.removeAll(localDigests);
            if (remoteDigests.isEmpty()) continue;
            this.deleteFilesRequest(remoteDigests.toArray(new BytesArray[remoteDigests.size()]));
        }
    }

    private void deleteFilesRequest(BytesArray[] digests) {
        PlainFuture listener = new PlainFuture();
        this.transportService.sendRequest(this.request.targetNode(), "internal:crate:blob/shard/recovery/delete_file", (TransportRequest)new BlobRecoveryDeleteRequest(this.request.recoveryId(), digests), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse.Empty>("internal:crate:blob/shard/recovery/delete_file", listener, streamInput -> TransportResponse.Empty.INSTANCE));
        FutureUtils.get(listener);
    }

    private void sendFinalizeRecoveryRequest() {
        PlainFuture listener = new PlainFuture();
        this.transportService.sendRequest(this.request.targetNode(), "internal:crate:blob/shard/recovery/finalize_recovery", (TransportRequest)new BlobFinalizeRecoveryRequest(this.request.recoveryId()), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse.Empty>("internal:crate:blob/shard/recovery/finalize_recovery", listener, streamInput -> TransportResponse.Empty.INSTANCE));
        FutureUtils.get(listener);
    }

    private void sendStartRecoveryRequest() {
        PlainFuture listener = new PlainFuture();
        this.transportService.sendRequest(this.request.targetNode(), "internal:crate:blob/shard/recovery/start", (TransportRequest)new BlobStartRecoveryRequest(this.request.recoveryId(), this.request.shardId()), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse.Empty>("internal:crate:blob/shard/recovery/start", listener, streamInput -> TransportResponse.Empty.INSTANCE));
        FutureUtils.get(listener);
    }

    private class TransferFileRunnable
    implements CancellableThreads.Interruptable {
        private final AtomicReference<Exception> lastException;
        private final String baseDir;
        private final File file;
        private final CountDownLatch latch;

        TransferFileRunnable(File filePath, AtomicReference<Exception> lastException, CountDownLatch latch) {
            this.file = filePath;
            this.lastException = lastException;
            this.latch = latch;
            this.baseDir = BlobRecoveryHandler.this.blobShard.blobContainer().getBaseDirectory().toAbsolutePath().toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int BUFFER_SIZE = 16384;
                long fileSize = this.file.length();
                if (fileSize == 0L) {
                    LOGGER.warn("[{}][{}] empty file: {}", (Object)BlobRecoveryHandler.this.request.shardId().getIndexName(), (Object)BlobRecoveryHandler.this.request.shardId().id(), (Object)this.file.getName());
                }
                try (FileInputStream fileStream = new FileInputStream(this.file);){
                    String filePath = this.file.getAbsolutePath();
                    String relPath = filePath.substring(this.baseDir.length() + 1);
                    assert (!relPath.startsWith("/")) : "relPath must not start with a /";
                    byte[] buf = new byte[16384];
                    int bytesRead = fileStream.read(buf, 0, 16384);
                    long bytesReadTotal = 0L;
                    BytesArray content = new BytesArray(buf, 0, bytesRead);
                    BlobRecoveryStartTransferRequest startTransferRequest = new BlobRecoveryStartTransferRequest(BlobRecoveryHandler.this.request.recoveryId(), relPath, content, fileSize);
                    if (bytesRead > 0) {
                        bytesReadTotal += (long)bytesRead;
                        LOGGER.trace("[{}][{}] send BlobRecoveryStartTransferRequest to {} for file {} with size {}", (Object)BlobRecoveryHandler.this.request.shardId().getIndexName(), (Object)BlobRecoveryHandler.this.request.shardId().id(), (Object)BlobRecoveryHandler.this.request.targetNode().getName(), (Object)relPath, (Object)fileSize);
                        PlainFuture listener = new PlainFuture();
                        BlobRecoveryHandler.this.transportService.sendRequest(BlobRecoveryHandler.this.request.targetNode(), "internal:crate:blob/shard/recovery/start_transfer", (TransportRequest)startTransferRequest, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse.Empty>("internal:crate:blob/shard/recovery/start_transfer", listener, streamInput -> TransportResponse.Empty.INSTANCE));
                        FutureUtils.get(listener);
                        boolean isLast = false;
                        boolean sentChunks = false;
                        while ((bytesRead = fileStream.read(buf, 0, 16384)) > 0) {
                            sentChunks = true;
                            bytesReadTotal += (long)bytesRead;
                            if (BlobRecoveryHandler.this.shard.state() == IndexShardState.CLOSED) {
                                throw new IndexShardClosedException(BlobRecoveryHandler.this.shard.shardId());
                            }
                            if (bytesReadTotal == fileSize) {
                                isLast = true;
                            }
                            content = new BytesArray(buf, 0, bytesRead);
                            PlainFuture transferChunkListener = new PlainFuture();
                            BlobRecoveryHandler.this.transportService.sendRequest(BlobRecoveryHandler.this.request.targetNode(), "internal:crate:blob/shard/recovery/transfer_chunk", (TransportRequest)new BlobRecoveryChunkRequest(BlobRecoveryHandler.this.request.recoveryId(), startTransferRequest.transferId(), content, isLast), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse.Empty>("internal:crate:blob/shard/recovery/transfer_chunk", transferChunkListener, streamInput -> TransportResponse.Empty.INSTANCE));
                            FutureUtils.get(transferChunkListener);
                        }
                        if (!isLast && sentChunks) {
                            LOGGER.error("Sending isLast because it wasn't sent before for {}", (Object)relPath);
                            PlainFuture transferMissingChunkListener = new PlainFuture();
                            BlobRecoveryHandler.this.transportService.sendRequest(BlobRecoveryHandler.this.request.targetNode(), "internal:crate:blob/shard/recovery/transfer_chunk", (TransportRequest)new BlobRecoveryChunkRequest(BlobRecoveryHandler.this.request.recoveryId(), startTransferRequest.transferId(), BytesArray.EMPTY, true), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse.Empty>("internal:crate:blob/shard/recovery/transfer_chunk", transferMissingChunkListener, streamInput -> TransportResponse.Empty.INSTANCE));
                            FutureUtils.get(transferMissingChunkListener);
                        }
                    }
                    LOGGER.trace("[{}][{}] completed to transfer file {} to {}", (Object)BlobRecoveryHandler.this.request.shardId().getIndexName(), (Object)BlobRecoveryHandler.this.request.shardId().id(), (Object)this.file.getName(), (Object)BlobRecoveryHandler.this.request.targetNode().getName());
                }
            }
            catch (IOException ex) {
                LOGGER.error("exception while file transfer", (Throwable)ex);
                this.lastException.set(ex);
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

