/*
 * Decompiled with CFR 0.152.
 */
package io.crate.breaker;

import io.crate.common.annotations.ThreadSafe;
import io.crate.data.breaker.RamAccounting;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.unit.ByteSizeValue;

@ThreadSafe
public final class ConcurrentRamAccounting
implements RamAccounting {
    private final AtomicLong usedBytes = new AtomicLong(0L);
    private final LongConsumer reserveBytes;
    private final LongConsumer releaseBytes;
    private final String label;
    private final int operationMemoryLimit;

    public static ConcurrentRamAccounting forCircuitBreaker(String label, CircuitBreaker circuitBreaker, int operationMemoryLimit) {
        return new ConcurrentRamAccounting(bytes -> circuitBreaker.addEstimateBytesAndMaybeBreak(bytes, label), bytes -> circuitBreaker.addWithoutBreaking(-bytes), label, operationMemoryLimit);
    }

    public ConcurrentRamAccounting(LongConsumer reserveBytes, LongConsumer releaseBytes, String label, int operationMemoryLimit) {
        this.reserveBytes = reserveBytes;
        this.releaseBytes = releaseBytes;
        this.label = label;
        this.operationMemoryLimit = operationMemoryLimit;
    }

    public void addBytes(long bytes) {
        if (bytes == 0L) {
            return;
        }
        long currentUsedBytes = this.usedBytes.addAndGet(bytes);
        if (this.operationMemoryLimit > 0 && currentUsedBytes > (long)this.operationMemoryLimit) {
            this.usedBytes.addAndGet(-bytes);
            throw new CircuitBreakingException(String.format(Locale.ENGLISH, "\"%s\" reached operation memory limit. Used: %s, Limit: %s", this.label, new ByteSizeValue(currentUsedBytes), new ByteSizeValue(this.operationMemoryLimit)));
        }
        try {
            if (bytes > 0L) {
                this.reserveBytes.accept(bytes);
            } else {
                this.releaseBytes.accept(-bytes);
            }
        }
        catch (Exception e) {
            this.usedBytes.addAndGet(-bytes);
            throw e;
        }
    }

    public long totalBytes() {
        return this.usedBytes.get();
    }

    public void release() {
        long prevUsedBytes = this.usedBytes.getAndSet(0L);
        this.releaseBytes.accept(prevUsedBytes);
    }

    public void close() {
        this.release();
    }
}

