/*
 * Decompiled with CFR 0.152.
 */
package io.crate.breaker;

import io.crate.breaker.CellsSizeEstimator;
import io.crate.data.Row;
import io.crate.data.breaker.RamAccounting;
import io.crate.data.breaker.RowAccounting;
import io.crate.types.DataType;
import java.util.List;

public class TypedRowAccounting
implements RowAccounting<Row> {
    private final RamAccounting ramAccounting;
    private final CellsSizeEstimator estimateRowSize;
    private int extraSizePerRow = 0;

    public TypedRowAccounting(List<? extends DataType<?>> columnTypes, RamAccounting ramAccounting) {
        this.estimateRowSize = CellsSizeEstimator.forColumns(columnTypes);
        this.ramAccounting = ramAccounting;
    }

    public TypedRowAccounting(List<? extends DataType<?>> columnTypes, RamAccounting ramAccounting, int extraSizePerRow) {
        this(columnTypes, ramAccounting);
        this.extraSizePerRow = extraSizePerRow;
    }

    public long accountForAndMaybeBreak(Row row) {
        long bytes = this.estimateRowSize.estimateSize(row) + (long)this.extraSizePerRow;
        this.ramAccounting.addBytes(bytes);
        return bytes;
    }

    public void release() {
        this.ramAccounting.release();
    }
}

