/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.expression.symbol.Symbol;
import io.crate.types.DataType;
import java.util.Arrays;
import java.util.Locale;

public class ConversionException
extends IllegalArgumentException {
    public ConversionException(Symbol source, DataType<?> targetType) {
        super(String.format(Locale.ENGLISH, "Cannot cast `%s` of type `%s` to %s", source, source.valueType(), "type `" + String.valueOf(targetType) + "`"));
    }

    public ConversionException(DataType<?> sourceType, DataType<?> targetType) {
        super(String.format(Locale.ENGLISH, "Cannot cast expressions from type `%s` to type `%s`", sourceType, targetType));
    }

    public ConversionException(Object sourceValue, DataType<?> targetType) {
        super(String.format(Locale.ENGLISH, "Cannot cast value `%s` to type `%s`", sourceValue.getClass().isArray() ? Arrays.deepToString((Object[])sourceValue) : sourceValue, targetType));
    }

    public static ConversionException forObjectChild(String key, Object sourceValue, DataType<?> targetType) {
        return new ConversionException(String.format(Locale.ENGLISH, "Cannot cast object element `%s` with value `%s` to type `%s`", key, sourceValue, targetType));
    }

    private ConversionException(String message) {
        super(message);
    }
}

