/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.UnscopedException;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;

public final class TaskMissing
extends ElasticsearchException
implements UnscopedException {
    public TaskMissing(StreamInput in) throws IOException {
        super(in);
    }

    public TaskMissing(Type type, UUID jobId) {
        super(String.format(Locale.ENGLISH, "%s for job %s not found", type.friendlyName(), jobId), new Object[0]);
    }

    public TaskMissing(Type type, UUID jobId, int phaseId) {
        super(String.format(Locale.ENGLISH, "%s for job %s with id '%d' not found", type.friendlyName(), jobId, phaseId), new Object[0]);
    }

    public static enum Type {
        ROOT("RootTask"),
        CHILD("Task");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String friendlyName() {
            return this.name;
        }
    }
}

