/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.index;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.index.SwapAndDropIndexRequest;
import io.crate.metadata.cluster.SwapAndDropIndexExecutor;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSwapAndDropIndexName
extends AbstractDDLTransportAction<SwapAndDropIndexRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final SwapAndDropIndexExecutor executor;

    @Inject
    public TransportSwapAndDropIndexName(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService) {
        super(ACTION.name(), transportService, clusterService, threadPool, SwapAndDropIndexRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "swap-and-drop-index");
        this.executor = new SwapAndDropIndexExecutor(allocationService);
    }

    @Override
    public ClusterStateTaskExecutor<SwapAndDropIndexRequest> clusterStateTaskExecutor(SwapAndDropIndexRequest request) {
        return this.executor;
    }

    @Override
    protected ClusterBlockException checkBlock(SwapAndDropIndexRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, new String[]{request.source(), request.target()});
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:sql/index/swap_and_drop_index";

        private Action() {
            super(NAME);
        }
    }
}

