/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.RelationName;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DropTableRequest
extends AcknowledgedRequest<DropTableRequest> {
    private final RelationName relationName;

    public DropTableRequest(RelationName relationName) {
        this.relationName = relationName;
    }

    public RelationName tableIdent() {
        return this.relationName;
    }

    public DropTableRequest(StreamInput in) throws IOException {
        super(in);
        this.relationName = new RelationName(in);
        if (in.getVersion().before(Version.V_5_8_0)) {
            in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.relationName.writeTo(out);
        if (out.getVersion().before(Version.V_5_8_0)) {
            out.writeBoolean(true);
        }
    }
}

