/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.exceptions.RelationAlreadyExists;
import io.crate.execution.ddl.tables.CreateTableRequest;
import io.crate.execution.ddl.tables.CreateTableResponse;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateTable
extends TransportMasterNodeAction<CreateTableRequest, CreateTableResponse> {
    public static final Action ACTION = new Action();
    private final MetadataCreateIndexService createIndexService;
    private final IndexScopedSettings indexScopedSettings;

    @Inject
    public TransportCreateTable(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexScopedSettings indexScopedSettings, MetadataCreateIndexService createIndexService) {
        super(ACTION.name(), transportService, clusterService, threadPool, CreateTableRequest::new);
        this.createIndexService = createIndexService;
        this.indexScopedSettings = indexScopedSettings;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected CreateTableResponse read(StreamInput in) throws IOException {
        return new CreateTableResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(CreateTableRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(final CreateTableRequest request, ClusterState state, ActionListener<CreateTableResponse> listener) {
        final RelationName relationName = request.getTableName();
        if (state.metadata().contains(relationName)) {
            listener.onFailure(new RelationAlreadyExists(relationName));
            return;
        }
        Settings.Builder settingsBuilder = Settings.builder().put(request.settings()).put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), state.nodes().getSmallestNonClientNodeVersion()).normalizePrefix("index.");
        final Settings normalizedSettings = settingsBuilder.build();
        this.indexScopedSettings.validate(normalizedSettings, true);
        try {
            DocTableInfo.checkTotalColumnsLimit(relationName, normalizedSettings, request.references().stream());
            DocTableInfo.checkObjectDepthLimit(relationName, normalizedSettings, request.references());
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        final boolean isPartitioned = !request.partitionedBy().isEmpty();
        ActionListener<Object> stateUpdateListener = isPartitioned ? listener.map(resp -> new CreateTableResponse(resp.isAcknowledged())) : this.createIndexService.withWaitForShards(listener, relationName.indexNameOrAlias(), ActiveShardCount.DEFAULT, request.ackTimeout(), (stateAck, shardsAck) -> new CreateTableResponse(stateAck != false && shardsAck != false));
        AckedClusterStateUpdateTask<ClusterStateUpdateResponse> createTableTask = new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(this, Priority.URGENT, (AckedRequest)request, stateUpdateListener){
            final /* synthetic */ TransportCreateTable this$0;
            {
                this.this$0 = this$0;
                super(priority, request2, listener);
            }

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                String indexName = relationName.indexNameOrAlias();
                MetadataCreateIndexService.validateIndexName(indexName, currentState);
                ClusterState newState = ClusterState.builder(currentState).build();
                Metadata newMetadata = Metadata.builder(newState.metadata()).setTable(relationName, request.references(), normalizedSettings, request.routingColumn(), request.tableColumnPolicy(), request.pkConstraintName(), request.checkConstraints(), request.primaryKeys(), request.partitionedBy(), IndexMetadata.State.OPEN, List.of(), 0L).build();
                RelationMetadata.Table table = (RelationMetadata.Table)newMetadata.getRelation(relationName);
                assert (table != null) : "table must not be null";
                newState = ClusterState.builder(newState).metadata(newMetadata).build();
                if (!isPartitioned) {
                    String newIndexUUID = UUIDs.randomBase64UUID();
                    newState = this.this$0.createIndexService.add(newState, table, newIndexUUID, List.of(), Settings.EMPTY);
                    Metadata.Builder mdBuilder = Metadata.builder(newState.metadata());
                    newMetadata = mdBuilder.addIndexUUIDs(table, List.of(newIndexUUID)).build();
                    newState = ClusterState.builder(newState).metadata(newMetadata).build();
                }
                return newState;
            }
        };
        this.clusterService.submitStateUpdateTask("create-table", createTableTask);
    }

    public static class Action
    extends ActionType<CreateTableResponse> {
        private static final String NAME = "internal:crate:sql/tables/admin/create";

        private Action() {
            super(NAME);
        }
    }
}

