/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.tables.AlterTableTask;
import io.crate.execution.ddl.tables.RenameColumnRequest;
import io.crate.metadata.NodeContext;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.VisibleForTesting;

public class TransportRenameColumn
extends AbstractDDLTransportAction<RenameColumnRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    @VisibleForTesting
    public static final AlterTableTask.AlterTableOperator<RenameColumnRequest> RENAME_COLUMN_OPERATOR = (req, docTableInfo, builder, nodeContext, fulltextAnalyzerResolver) -> docTableInfo.renameColumn(req.refToRename(), req.newName());
    private final NodeContext nodeContext;

    @Inject
    public TransportRenameColumn(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, NodeContext nodeContext) {
        super(ACTION.name(), transportService, clusterService, threadPool, RenameColumnRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "rename-column");
        this.nodeContext = nodeContext;
    }

    @Override
    public ClusterStateTaskExecutor<RenameColumnRequest> clusterStateTaskExecutor(RenameColumnRequest request) {
        return new AlterTableTask<RenameColumnRequest>(this.nodeContext, request.relationName(), null, RENAME_COLUMN_OPERATOR);
    }

    @Override
    public ClusterBlockException checkBlock(RenameColumnRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:sql/table/rename_column";

        private Action() {
            super(NAME);
        }
    }
}

