/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.views;

import io.crate.execution.ddl.views.CreateViewRequest;
import io.crate.execution.ddl.views.CreateViewResponse;
import io.crate.metadata.view.ViewsMetadata;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class TransportCreateView
extends TransportMasterNodeAction<CreateViewRequest, CreateViewResponse> {
    public static final Action ACTION = new Action();

    @Inject
    public TransportCreateView(TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(ACTION.name(), transportService, clusterService, threadPool, CreateViewRequest::new);
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected CreateViewResponse read(StreamInput in) throws IOException {
        return new CreateViewResponse(in);
    }

    @Override
    protected void masterOperation(final CreateViewRequest request, ClusterState state, ActionListener<CreateViewResponse> listener) {
        if (!request.replaceExisting() && state.metadata().contains(request.name())) {
            listener.onResponse(new CreateViewResponse(true));
        } else {
            this.clusterService.submitStateUpdateTask("views/create [" + String.valueOf(request.name()) + "]", new AckedClusterStateUpdateTask<CreateViewResponse>(this, Priority.HIGH, (AckedRequest)request, listener){
                boolean alreadyExitsFailure;
                {
                    super(priority, request2, listener);
                    this.alreadyExitsFailure = false;
                }

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ViewsMetadata views = (ViewsMetadata)currentState.metadata().custom("views");
                    if (currentState.metadata().contains(request.name())) {
                        boolean replacesView;
                        boolean bl = replacesView = request.replaceExisting() && views != null && views.contains(request.name());
                        if (!replacesView) {
                            this.alreadyExitsFailure = true;
                            return currentState;
                        }
                    }
                    return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("views", ViewsMetadata.addOrReplace(views, request.name(), request.query(), request.owner(), request.searchPath(), request.errorOnUnknownObjectKey())).build()).build();
                }

                @Override
                protected CreateViewResponse newResponse(boolean acknowledged) {
                    return new CreateViewResponse(this.alreadyExitsFailure);
                }
            });
        }
    }

    @Override
    protected ClusterBlockException checkBlock(CreateViewRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static class Action
    extends ActionType<CreateViewResponse> {
        private static final String NAME = "internal:crate:sql/views/create";

        private Action() {
            super(NAME);
        }
    }
}

