/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.exceptions.ConversionException;
import io.crate.execution.dml.IndexItem;
import io.crate.execution.dml.Indexer;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.server.xcontent.XContentHelper;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.jetbrains.annotations.NotNull;

public class RawIndexer {
    private final String indexName;
    private final DocTableInfo table;
    private final TransactionContext txnCtx;
    private final NodeContext nodeCtx;
    private final Symbol[] returnValues;
    private final Version shardVersionCreated;
    private final Map<Set<String>, Indexer> indexers = new HashMap<Set<String>, Indexer>();
    private final List<Reference> nonDeterministicSynthetics;
    private Indexer currentRowIndexer;
    private IndexItem.StaticItem currentItem;

    public RawIndexer(String indexName, DocTableInfo table, Version shardVersionCreated, TransactionContext txnCtx, NodeContext nodeCtx, Symbol[] returnValues, @NotNull List<Reference> nonDeterministicSynthetics) {
        this.indexName = indexName;
        this.table = table;
        this.txnCtx = txnCtx;
        this.nodeCtx = nodeCtx;
        this.returnValues = returnValues;
        this.nonDeterministicSynthetics = nonDeterministicSynthetics;
        this.shardVersionCreated = shardVersionCreated;
    }

    public List<Reference> collectSchemaUpdates(IndexItem item) throws IOException {
        int i;
        String raw = (String)item.insertValues()[0];
        Map<String, Object> doc = XContentHelper.convertToMap((XContent)JsonXContent.JSON_XCONTENT, raw, true);
        this.currentRowIndexer = this.indexers.computeIfAbsent(doc.keySet(), keys -> {
            ArrayList<Reference> targetRefs = new ArrayList<Reference>();
            for (String key : keys) {
                ColumnIdent column = ColumnIdent.of(key);
                Reference reference = this.table.getReference(column);
                if (reference == null) {
                    reference = this.table.getDynamic(column, true, this.txnCtx.sessionSettings().errorOnUnknownObjectKey());
                }
                targetRefs.add(reference);
            }
            targetRefs.addAll(this.nonDeterministicSynthetics);
            return new Indexer(this.indexName, this.table, this.shardVersionCreated, this.txnCtx, this.nodeCtx, targetRefs, null, this.returnValues);
        });
        int numExtra = item.insertValues().length - 1;
        assert (numExtra == this.nonDeterministicSynthetics.size()) : "Insert columns/values expansion must be done in sync";
        Object[] insertValues = new Object[doc.size() + numExtra];
        List<Reference> columns = this.currentRowIndexer.columns();
        for (i = 0; i < doc.size(); ++i) {
            Reference reference = columns.get(i);
            Object value = doc.get(reference.column().name());
            DataType<?> type = reference.valueType();
            try {
                insertValues[i] = type.implicitCast(value);
                continue;
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw new ConversionException(value, type);
            }
        }
        for (i = 0; i < numExtra; ++i) {
            insertValues[doc.size() + i] = item.insertValues()[i + 1];
        }
        this.currentItem = new IndexItem.StaticItem(item.id(), item.pkValues(), insertValues, item.seqNo(), item.primaryTerm());
        return this.currentRowIndexer.collectSchemaUpdates(this.currentItem);
    }

    public void updateTargets(DocTableInfo newTable) {
        for (Indexer indexer : this.indexers.values()) {
            indexer.updateTargets(newTable);
        }
    }

    public ParsedDocument index() throws IOException {
        assert (this.currentRowIndexer != null) : "Must be used only after collecting schema updates.";
        return this.currentRowIndexer.index(this.currentItem);
    }

    public Object[] addGeneratedValues(IndexItem item) {
        return this.currentRowIndexer.addGeneratedValues(item, true);
    }
}

